/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.blocks;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.telepathicgrunt.bumblezone.blocks.BzBlocks;
import net.telepathicgrunt.bumblezone.blocks.StickyHoneyResidue;

public class StickyHoneyRedstone
extends StickyHoneyResidue {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    protected static final AxisAlignedBB DOWN_REAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0);
    protected static final AxisAlignedBB UP_REAL_AABB = new AxisAlignedBB(0.0, 0.8, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB NORTH_REAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.2);
    protected static final AxisAlignedBB EAST_REAL_AABB = new AxisAlignedBB(0.8, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_REAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.2, 1.0, 1.0);
    protected static final AxisAlignedBB SOUTH_REAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.2, 1.0, 1.0, 1.0);
    public static final Map<Direction, AxisAlignedBB> FACING_TO_AABB_MAP;

    public StickyHoneyRedstone() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176277_a, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_176273_b, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_176278_M, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_176279_N, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_176280_O, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176277_a, field_176273_b, field_176278_M, field_176279_N, field_176280_O, DOWN, POWERED});
    }

    @Override
    @Deprecated
    public void func_196262_a(BlockState blockstate, World world, BlockPos pos, Entity entity) {
        this.updateState(world, pos, blockstate, 0);
        super.func_196262_a(blockstate, world, pos, entity);
    }

    public int func_180656_a(BlockState blockstate, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockstate.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    public void func_225534_a_(BlockState blockstate, ServerWorld world, BlockPos pos, Random rand) {
        this.updateState((World)world, pos, blockstate, (Boolean)blockstate.func_177229_b((IProperty)POWERED) != false ? 1 : 0);
    }

    protected void updateNeighbors(BlockState blockstate, World world, BlockPos pos) {
        if (ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (BlockState)world.func_180495_p(pos), EnumSet.allOf(Direction.class), (boolean)false).isCanceled() || blockstate.func_177230_c() != BzBlocks.STICKY_HONEY_REDSTONE.get()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BooleanProperty booleanproperty = StickyHoneyResidue.FACING_TO_PROPERTY_MAP.get(direction);
            if (!((Boolean)blockstate.func_177229_b((IProperty)booleanproperty)).booleanValue()) continue;
            world.func_190524_a(pos.func_177972_a(direction), blockstate.func_177230_c(), pos);
        }
    }

    public void func_196243_a(BlockState blockstate, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && blockstate.func_177230_c() != newState.func_177230_c()) {
            if (((Boolean)blockstate.func_177229_b((IProperty)POWERED)).booleanValue()) {
                this.updateNeighbors(blockstate, world, pos);
            }
            super.func_196243_a(blockstate, world, pos, newState, isMoving);
        }
    }

    protected void updateState(World world, BlockPos pos, BlockState oldBlockstate, int oldRedstoneStrength) {
        boolean flag1;
        int newPower = this.computeRedstoneStrength(oldBlockstate, world, pos);
        boolean bl = flag1 = newPower > 0;
        if (oldRedstoneStrength != newPower) {
            BlockState newBlockstate = this.setRedstoneStrength(oldBlockstate, newPower);
            world.func_180501_a(pos, newBlockstate, 2);
            this.updateNeighbors(oldBlockstate, world, pos);
            world.func_225319_b(pos, oldBlockstate, newBlockstate);
        }
        if (flag1) {
            world.func_205220_G_().func_205360_a(new BlockPos((Vec3i)pos), (Object)this, this.func_149738_a((IWorldReader)world));
        }
    }

    protected BlockState setRedstoneStrength(BlockState blockstate, int strength) {
        return (BlockState)blockstate.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(strength > 0));
    }

    protected int computeRedstoneStrength(BlockState blockstate, World world, BlockPos pos) {
        AxisAlignedBB axisalignedbb = this.func_220053_a(blockstate, (IBlockReader)world, pos, null).func_197752_a().func_186670_a(pos);
        List list = world.func_217357_a(LivingEntity.class, axisalignedbb);
        if (!list.isEmpty()) {
            return 1;
        }
        return 0;
    }

    static {
        HashMap<Direction, AxisAlignedBB> map = new HashMap<Direction, AxisAlignedBB>();
        map.put(Direction.DOWN, DOWN_REAL_AABB);
        map.put(Direction.UP, UP_REAL_AABB);
        map.put(Direction.EAST, EAST_REAL_AABB);
        map.put(Direction.WEST, WEST_REAL_AABB);
        map.put(Direction.NORTH, NORTH_REAL_AABB);
        map.put(Direction.SOUTH, SOUTH_REAL_AABB);
        FACING_TO_AABB_MAP = map;
    }
}

