/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiouselytra;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.ItemHandlerHelper;
import top.theillusivec4.caelus.api.CaelusAPI;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurio;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;
import top.theillusivec4.curiouselytra.CurioElytra;

@Mod(value="curiouselytra")
public class CuriousElytra {
    public static final String MODID = "curiouselytra";

    public CuriousElytra() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueue);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void enqueue(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("back"));
        InterModComms.sendTo((String)"caelus", (String)"elytraRender", () -> livingEntity -> {
            CaelusAPI.ElytraRender[] render = new CaelusAPI.ElytraRender[]{CaelusAPI.ElytraRender.NONE};
            CuriosAPI.getCurioEquipped((Item)Items.field_185160_cR, (LivingEntity)livingEntity).ifPresent(elytra -> {
                render[0] = ((ItemStack)elytra.getRight()).func_77948_v() ? CaelusAPI.ElytraRender.ENCHANTED : CaelusAPI.ElytraRender.NORMAL;
            });
            return render[0];
        });
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        if (!(stack.func_77973_b() instanceof ElytraItem)) {
            return;
        }
        final CurioElytra curioElytra = new CurioElytra(stack);
        evt.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){
            LazyOptional<ICurio> curio = LazyOptional.of(() -> curioElytra);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curio);
            }
        });
    }

    @SubscribeEvent
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent evt) {
        ItemStack to = evt.getTo();
        if (evt.getSlot() != EquipmentSlotType.CHEST || !(to.func_77973_b() instanceof ElytraItem)) {
            return;
        }
        LivingEntity livingBase = evt.getEntityLiving();
        CuriosAPI.getCurioEquipped((Item)Items.field_185160_cR, (LivingEntity)livingBase).ifPresent(elytra -> {
            ItemStack stack = (ItemStack)elytra.getRight();
            ItemStack copy = stack.func_77946_l();
            CuriosAPI.getCuriosHandler((LivingEntity)livingBase).ifPresent(handler -> handler.setStackInSlot((String)elytra.getLeft(), ((Integer)elytra.getMiddle()).intValue(), ItemStack.field_190927_a));
            if (livingBase instanceof PlayerEntity) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)((PlayerEntity)livingBase), (ItemStack)copy);
            } else {
                livingBase.func_199701_a_(copy);
            }
        });
    }
}

