/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.generator;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hrznstudio.titanium.recipe.generator.IJSONGenerator;
import com.hrznstudio.titanium.recipe.generator.IJsonFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TitaniumSerializableProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;
    private final Map<IJsonFile, IJSONGenerator> serializables;
    private final String modid;

    public TitaniumSerializableProvider(DataGenerator generatorIn, String modid) {
        this.generator = generatorIn;
        this.modid = modid;
        this.serializables = new HashMap<IJsonFile, IJSONGenerator>();
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.add(this.serializables);
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        this.serializables.forEach((iJsonFile, ijsonGenerator) -> {
            Path outputFile = path.resolve("data/" + this.modid + "/recipes/" + (iJsonFile.getRecipeSubfolder() != null ? iJsonFile.getRecipeSubfolder() + "/" : "") + iJsonFile.getRecipeKey() + ".json");
            if (!set.add(outputFile)) {
                throw new IllegalStateException("Duplicate recipe " + iJsonFile.getRecipeKey());
            }
            this.saveRecipe(cache, ijsonGenerator.generate(), outputFile);
        });
    }

    protected void saveRecipe(DirectoryCache cache, JsonObject recipeJson, Path output) {
        try {
            String s = GSON.toJson((JsonElement)recipeJson);
            String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
            if (!Objects.equals(cache.func_208323_a(output), s1) || !Files.exists(output, new LinkOption[0])) {
                Files.createDirectories(output.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(output, new OpenOption[0]);){
                    bufferedwriter.write(s);
                }
            }
            cache.func_208316_a(output, s1);
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save recipe {}", (Object)output, (Object)ioexception);
        }
    }

    public abstract void add(Map<IJsonFile, IJSONGenerator> var1);

    public String func_200397_b() {
        return "Titanium Serializable (" + this.modid + ")";
    }
}

