/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import xreliquary.init.ModItems;
import xreliquary.items.MobCharmDefinition;
import xreliquary.items.MobCharmItem;

public class StandardMobCharmRegistry {
    private static final Map<String, MobCharmDefinition> REGISTERED_CHARM_DEFINITIONS = new HashMap<String, MobCharmDefinition>();
    private static final Map<String, MobCharmDefinition> ENTITY_NAME_CHARM_DEFINITIONS = new HashMap<String, MobCharmDefinition>();

    private StandardMobCharmRegistry() {
    }

    private static void registerMobCharmDefinition(MobCharmDefinition charmDefinition) {
        REGISTERED_CHARM_DEFINITIONS.put(charmDefinition.getRegistryName(), charmDefinition);
        for (String registryName : charmDefinition.getEntities()) {
            ENTITY_NAME_CHARM_DEFINITIONS.put(registryName, charmDefinition);
        }
    }

    static Optional<MobCharmDefinition> getCharmDefinitionFor(Entity entity) {
        return Optional.ofNullable(ENTITY_NAME_CHARM_DEFINITIONS.get(entity.func_200600_R().getRegistryName().toString()));
    }

    public static Optional<MobCharmDefinition> getCharmDefinitionFor(ItemStack stack) {
        if (stack.func_77973_b() != ModItems.MOB_CHARM) {
            return Optional.empty();
        }
        return Optional.ofNullable(ENTITY_NAME_CHARM_DEFINITIONS.get(MobCharmItem.getEntityRegistryName(stack)));
    }

    public static Set<String> getRegisteredNames() {
        return REGISTERED_CHARM_DEFINITIONS.keySet();
    }

    static {
        StandardMobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.ZOMBIE);
        StandardMobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.SKELETON);
        StandardMobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.WITHER_SKELETON);
        StandardMobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.CREEPER);
        StandardMobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.WITCH);
        StandardMobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.ZOMBIE_PIGMAN);
        StandardMobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.CAVE_SPIDER);
        StandardMobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.SPIDER);
        StandardMobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.ENDERMAN);
        StandardMobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.GHAST);
        StandardMobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.SLIME);
        StandardMobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.MAGMA_CUBE);
        StandardMobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.BLAZE);
        StandardMobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.GUARDIAN);
    }
}

