/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xreliquary.items.ItemBase;
import xreliquary.items.util.IPotionItem;
import xreliquary.util.LanguageHelper;
import xreliquary.util.potions.PotionEssence;
import xreliquary.util.potions.PotionMap;
import xreliquary.util.potions.XRPotionHelper;

public class BulletItem
extends ItemBase
implements IPotionItem {
    private final boolean hasTooltip;
    private final boolean addPotionBulletsInItemGroup;
    private final int color;

    public BulletItem(String name, boolean hasTooltip, boolean addPotionBulletsInItemGroup, int color) {
        super(name, new Item.Properties().setNoRepair());
        this.hasTooltip = hasTooltip;
        this.addPotionBulletsInItemGroup = addPotionBulletsInItemGroup;
        this.color = color;
        this.func_185043_a(new ResourceLocation("potion"), (stack, world, livingEntity) -> this.isPotionAttached(stack) ? 1.0f : 0.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (this.hasTooltip) {
            LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip", null, tooltip);
        }
        XRPotionHelper.addPotionTooltip(stack, tooltip);
    }

    private boolean isPotionAttached(ItemStack stack) {
        return !XRPotionHelper.getPotionEffectsFromStack(stack).isEmpty();
    }

    public void func_150895_a(ItemGroup itemGroup, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(itemGroup)) {
            return;
        }
        items.add((Object)new ItemStack((IItemProvider)this));
        if (!this.addPotionBulletsInItemGroup) {
            return;
        }
        for (PotionEssence essence : PotionMap.uniquePotionEssences) {
            ItemStack bullet = new ItemStack((IItemProvider)this);
            XRPotionHelper.addPotionEffectsToStack(bullet, XRPotionHelper.changePotionEffectsDuration(essence.getEffects(), 0.2f));
            items.add((Object)bullet);
        }
    }

    @Override
    public List<EffectInstance> getEffects(ItemStack stack) {
        return XRPotionHelper.getPotionEffectsFromStack(stack);
    }

    public int getColor() {
        return this.color;
    }
}

