/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.handler;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import xreliquary.handler.HandlerPriorityComparator;
import xreliquary.handler.IPlayerDeathHandler;
import xreliquary.handler.IPlayerHurtHandler;
import xreliquary.init.ModItems;
import xreliquary.util.XRFakePlayerFactory;

@Mod.EventBusSubscriber(modid="xreliquary")
public class CommonEventHandler {
    private static final Set<IPlayerHurtHandler> playerHurtHandlers = Sets.newTreeSet((Comparator)new HandlerPriorityComparator());
    private static final Set<IPlayerDeathHandler> playerDeathHandlers = Sets.newTreeSet((Comparator)new HandlerPriorityComparator());
    private static Map<UUID, Boolean> playersFlightStatus = new HashMap<UUID, Boolean>();

    private CommonEventHandler() {
    }

    public static void registerPlayerHurtHandler(IPlayerHurtHandler handler) {
        playerHurtHandlers.add(handler);
    }

    public static void registerPlayerDeathHandler(IPlayerDeathHandler handler) {
        playerDeathHandlers.add(handler);
    }

    @SubscribeEvent
    public static void preventMendingAndUnbreaking(AnvilUpdateEvent event) {
        if (event.getLeft().func_190926_b() || event.getRight().func_190926_b()) {
            return;
        }
        if (event.getLeft().func_77973_b() != ModItems.MOB_CHARM && event.getLeft().func_77973_b() != ModItems.ALKAHESTRY_TOME) {
            return;
        }
        if (EnchantmentHelper.func_82781_a((ItemStack)event.getRight()).keySet().stream().anyMatch(e -> e == Enchantments.field_185307_s)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void blameDrullkus(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer().func_146103_bH().getName().equals("Drullkus") && !event.getPlayer().getPersistentData().func_74764_b("gift") && event.getPlayer().field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModItems.WITCH_HAT))) {
            event.getPlayer().getPersistentData().func_74757_a("gift", true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void beforePlayerHurt(LivingAttackEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        boolean cancel = false;
        for (IPlayerHurtHandler handler : playerHurtHandlers) {
            if (!handler.canApply(player, event) || !handler.apply(player, event)) continue;
            cancel = true;
            break;
        }
        if (cancel) {
            event.setCanceled(true);
            event.setResult(null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void beforePlayerDeath(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        boolean cancel = false;
        for (IPlayerDeathHandler handler : playerDeathHandlers) {
            if (!handler.canApply(player, event) || !handler.apply(player, event)) continue;
            cancel = true;
            break;
        }
        if (cancel) {
            event.setCanceled(true);
            event.setResult(null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onDimensionUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof ServerWorld) {
            XRFakePlayerFactory.unloadWorld((ServerWorld)event.getWorld());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        PlayerEntity player = event.player;
        if (player.func_184587_cr() && player.func_184607_cu().func_77973_b() == ModItems.RENDING_GALE && ModItems.RENDING_GALE.isFlightMode(player.func_184607_cu()) && ModItems.RENDING_GALE.hasFlightCharge(player.func_184607_cu())) {
            playersFlightStatus.put(player.func_146103_bH().getId(), true);
            player.field_71075_bZ.field_75101_c = true;
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
        } else {
            if (!playersFlightStatus.containsKey(player.func_146103_bH().getId())) {
                playersFlightStatus.put(player.func_146103_bH().getId(), false);
                return;
            }
            boolean isFlying = playersFlightStatus.get(player.func_146103_bH().getId());
            if (isFlying) {
                playersFlightStatus.put(player.func_146103_bH().getId(), false);
                if (!player.func_184812_l_()) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                    ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
                }
            }
        }
    }
}

