/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.shot;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xreliquary.entities.ConcussiveExplosion;
import xreliquary.entities.shot.ShotEntityBase;
import xreliquary.init.ModEntities;
import xreliquary.reference.ClientReference;

public class SandShotEntity
extends ShotEntityBase {
    public SandShotEntity(EntityType<SandShotEntity> entityType, World world) {
        super(entityType, world);
    }

    public SandShotEntity(World world, PlayerEntity player, Hand hand) {
        super(ModEntities.SAND_SHOT, world, player, hand);
    }

    @Override
    void doFiringEffects() {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197608_a, this.func_226277_ct_() + this.smallGauss(0.1), this.func_226278_cu_() + this.smallGauss(0.1), this.func_226281_cx_() + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((IParticleData)ParticleTypes.field_197631_x);
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            this.spawnHitParticles(1);
        }
    }

    @Override
    void doBurstEffect(Direction sideHit) {
        this.spawnHitParticles(8);
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.field_70170_p.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (double)0.7f, (double)0.7f, (double)0.3f);
        }
    }

    @Override
    int getDamageOfShot(LivingEntity e) {
        if (e instanceof CreeperEntity) {
            ConcussiveExplosion.customBusterExplosion(this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 2.0f);
            e.func_70097_a(DamageSource.func_76365_a((PlayerEntity)this.shootingEntity), 20.0f);
            return 0;
        }
        if (e instanceof MobEntity) {
            e.func_195064_c(new EffectInstance(Effects.field_76440_q, 200, 1));
        }
        return (this.field_70170_p.func_72912_H().func_76059_o() ? 4 : 8) + this.d6();
    }

    @Override
    int getRicochetMax() {
        return 0;
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.SAND;
    }
}

