/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xreliquary.crafting.AlkahestryRecipeRegistry;
import xreliquary.init.ModItems;
import xreliquary.items.AlkahestryTomeItem;
import xreliquary.reference.Settings;

public class AlkahestryChargingRecipe
implements ICraftingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final Ingredient chargingIngredient;
    private final int chargeToAdd;
    private final ItemStack recipeOutput;
    private final ResourceLocation id;
    private final Ingredient tomeIngredient;

    private AlkahestryChargingRecipe(ResourceLocation id, Ingredient chargingIngredient, int chargeToAdd) {
        this.id = id;
        this.chargingIngredient = chargingIngredient;
        this.chargeToAdd = chargeToAdd;
        this.tomeIngredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{AlkahestryTomeItem.setCharge(new ItemStack((IItemProvider)ModItems.ALKAHESTRY_TOME), 0)});
        this.recipeOutput = new ItemStack((IItemProvider)ModItems.ALKAHESTRY_TOME);
        AlkahestryTomeItem.addCharge(this.recipeOutput, chargeToAdd);
        AlkahestryRecipeRegistry.registerChargingRecipe(this);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        boolean hasTome = false;
        boolean hasIngredient = false;
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack slotStack = inv.func_70301_a(x);
            if (slotStack.func_190926_b()) continue;
            boolean inRecipe = false;
            if (this.chargingIngredient.test(slotStack)) {
                inRecipe = true;
                hasIngredient = true;
            } else if (!hasTome && slotStack.func_77973_b() == ModItems.ALKAHESTRY_TOME && AlkahestryTomeItem.getCharge(slotStack) + this.chargeToAdd <= AlkahestryTomeItem.getChargeLimit()) {
                inRecipe = true;
                hasTome = true;
            }
            if (inRecipe) continue;
            return false;
        }
        return hasIngredient && hasTome;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        int numberOfIngredients = 0;
        ItemStack tome = ItemStack.field_190927_a;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (this.chargingIngredient.test(stack)) {
                ++numberOfIngredients;
                continue;
            }
            if (stack.func_77973_b() != ModItems.ALKAHESTRY_TOME) continue;
            tome = stack.func_77946_l();
        }
        AlkahestryTomeItem.addCharge(tome, this.chargeToAdd * numberOfIngredients);
        return tome;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.chargingIngredient, this.tomeIngredient});
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public int getChargeToAdd() {
        return this.chargeToAdd;
    }

    public Ingredient getChargingIngredient() {
        return this.chargingIngredient;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AlkahestryChargingRecipe> {
        public AlkahestryChargingRecipe read(ResourceLocation recipeId, JsonObject json) {
            if (Boolean.TRUE.equals(Settings.COMMON.disable.disableAlkahestry.get())) {
                return null;
            }
            if (!json.has("ingredient")) {
                throw new JsonParseException("No ingredient for alkahestry charging recipe");
            }
            Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)json.get("ingredient"));
            int chargeToAdd = JSONUtils.func_151203_m((JsonObject)json, (String)"charge");
            return new AlkahestryChargingRecipe(recipeId, ingredient, chargeToAdd);
        }

        @Nullable
        public AlkahestryChargingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new AlkahestryChargingRecipe(recipeId, Ingredient.func_199566_b((PacketBuffer)buffer), buffer.readInt());
        }

        public void write(PacketBuffer buffer, AlkahestryChargingRecipe recipe) {
            recipe.chargingIngredient.func_199564_a(buffer);
            buffer.writeInt(recipe.chargeToAdd);
        }
    }
}

