/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.jei;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;

class SortedNbtSubtypeInterpreter
implements ISubtypeInterpreter {
    private Set<String> keysToConsider;
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");

    SortedNbtSubtypeInterpreter(String ... keysToConsider) {
        this.keysToConsider = new HashSet<String>(Arrays.asList(keysToConsider));
    }

    public String apply(ItemStack itemStack) {
        CompoundNBT nbtTagCompound = itemStack.func_77978_p();
        return nbtTagCompound != null && !nbtTagCompound.isEmpty() ? this.getSortedCompoundString(nbtTagCompound, k -> this.keysToConsider.contains(k)) : "";
    }

    private String handleEscape(String keyName) {
        return SIMPLE_VALUE.matcher(keyName).matches() ? keyName : StringNBT.func_197654_a((String)keyName);
    }

    private String getSortedCompoundString(CompoundNBT nbtTagCompound, Predicate<String> addKey) {
        StringBuilder stringbuilder = new StringBuilder("{");
        List sortedKeys = nbtTagCompound.func_150296_c().stream().filter(addKey).sorted().collect(Collectors.toList());
        for (String s : sortedKeys) {
            if (stringbuilder.length() != 1) {
                stringbuilder.append(',');
            }
            INBT nbtValue = nbtTagCompound.func_74781_a(s);
            stringbuilder.append(this.handleEscape(s)).append(':').append(this.getNbtString(nbtValue));
        }
        return stringbuilder.append('}').toString();
    }

    private String getNbtString(INBT nbtValue) {
        if (nbtValue instanceof ListNBT) {
            return this.getNbtListString((ListNBT)nbtValue);
        }
        if (nbtValue instanceof CompoundNBT) {
            return this.getSortedCompoundString((CompoundNBT)nbtValue, k -> true);
        }
        return nbtValue.toString();
    }

    private String getNbtListString(ListNBT listNBT) {
        StringBuilder stringbuilder = new StringBuilder("[");
        for (int i = 0; i < listNBT.size(); ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.getNbtString(listNBT.get(i)));
        }
        return stringbuilder.append(']').toString();
    }
}

