/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks.tile;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.registries.ObjectHolder;
import xreliquary.blocks.AlkahestryAltarBlock;
import xreliquary.blocks.tile.TileEntityBase;
import xreliquary.reference.Settings;
import xreliquary.util.InjectionHelper;

public class AlkahestryAltarTileEntity
extends TileEntityBase
implements ITickableTileEntity {
    @ObjectHolder(value="xreliquary:alkahestry_altar")
    public static final TileEntityType<AlkahestryAltarTileEntity> TYPE = (TileEntityType)InjectionHelper.nullValue();
    private int cycleTime = 0;
    private boolean isActive;
    private int redstoneCount = 0;

    public AlkahestryAltarTileEntity() {
        super(TYPE);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || !this.isActive || this.field_145850_b.func_72820_D() >= 12000L || !this.field_145850_b.func_226660_f_(this.func_174877_v().func_177984_a())) {
            return;
        }
        if (this.cycleTime > 0) {
            --this.cycleTime;
        } else {
            this.isActive = false;
            this.field_145850_b.func_175656_a(this.func_174877_v().func_177984_a(), Blocks.field_150426_aN.func_176223_P());
            AlkahestryAltarBlock.updateAltarBlockState(this.isActive(), this.field_145850_b, this.func_174877_v());
        }
    }

    public void startCycle() {
        int defaultCycleTime = (Integer)Settings.COMMON.blocks.altar.timeInMinutes.get() * 60 * 20;
        int maximumVariance = (Integer)Settings.COMMON.blocks.altar.maximumTimeVarianceInMinutes.get() * 60 * 20;
        this.cycleTime = (int)((double)defaultCycleTime + (double)maximumVariance * this.field_145850_b.field_73012_v.nextGaussian());
        this.redstoneCount = 0;
        this.isActive = true;
    }

    public void stopCycle() {
        this.isActive = false;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.cycleTime = compound.func_74765_d("cycleTime");
        this.redstoneCount = compound.func_74765_d("redstoneCount");
        this.isActive = compound.func_74767_n("isActive");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("cycleTime", (short)this.cycleTime);
        compound.func_74777_a("redstoneCount", (short)this.redstoneCount);
        compound.func_74757_a("isActive", this.isActive);
        return compound;
    }

    public void addRedstone() {
        ++this.redstoneCount;
        if (this.redstoneCount >= AlkahestryAltarTileEntity.getRedstoneCost()) {
            AlkahestryAltarBlock.updateAltarBlockState(true, this.field_145850_b, this.func_174877_v());
        }
        BlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
    }

    private static int getRedstoneCost() {
        return (Integer)Settings.COMMON.blocks.altar.redstoneCost.get();
    }

    public int getRedstoneCount() {
        return this.redstoneCount;
    }

    private boolean isActive() {
        return this.isActive;
    }

    public int getCycleTime() {
        return this.cycleTime;
    }
}

