/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.message;

import com.raoulvdberge.refinedpipes.network.NetworkManager;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.Attachment;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.extractor.ExtractorAttachment;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.extractor.RoutingMode;
import com.raoulvdberge.refinedpipes.tile.PipeTileEntity;
import com.raoulvdberge.refinedpipes.util.DirectionUtil;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class ChangeRoutingModeMessage {
    private final BlockPos pos;
    private final Direction direction;
    private final RoutingMode routingMode;

    public ChangeRoutingModeMessage(BlockPos pos, Direction direction, RoutingMode routingMode) {
        this.pos = pos;
        this.direction = direction;
        this.routingMode = routingMode;
    }

    public static void encode(ChangeRoutingModeMessage message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.writeByte(message.direction.ordinal());
        buf.writeByte(message.routingMode.ordinal());
    }

    public static ChangeRoutingModeMessage decode(PacketBuffer buf) {
        BlockPos pos = buf.func_179259_c();
        Direction direction = DirectionUtil.safeGet(buf.readByte());
        RoutingMode redstoneMode = RoutingMode.get(buf.readByte());
        return new ChangeRoutingModeMessage(pos, direction, redstoneMode);
    }

    public static void handle(ChangeRoutingModeMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Attachment attachment;
            TileEntity tile = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_175625_s(message.pos);
            if (tile instanceof PipeTileEntity && (attachment = ((PipeTileEntity)tile).getAttachmentManager().getAttachment(message.direction)) instanceof ExtractorAttachment) {
                ((ExtractorAttachment)attachment).setRoutingMode(message.routingMode);
                NetworkManager.get(tile.func_145831_w()).func_76185_a();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

