/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.mysticalagriculture.crafting.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Random;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FarmlandTillRecipe
extends ShapelessRecipe {
    public FarmlandTillRecipe(ResourceLocation id, String group, ItemStack output, NonNullList<Ingredient> inputs) {
        super(id, group, output, inputs);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList remaining = super.func_179532_b((IInventory)inv);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof HoeItem)) continue;
            ItemStack hoe = stack.func_77946_l();
            hoe.func_96631_a(1, new Random(), null);
            remaining.set(i, (Object)hoe);
        }
        return remaining;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.CRAFTING_FARMLAND_TILL;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FarmlandTillRecipe> {
        public FarmlandTillRecipe read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new FarmlandTillRecipe(recipeId, s, itemstack, ingredients);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray array) {
            NonNullList ingredients = NonNullList.func_191196_a();
            for (int i = 0; i < array.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)array.get(i));
                if (ingredient.func_203189_d()) continue;
                ingredients.add((Object)ingredient);
            }
            return ingredients;
        }

        public FarmlandTillRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            int i = buffer.func_150792_a();
            NonNullList inputs = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < inputs.size(); ++j) {
                inputs.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            return new FarmlandTillRecipe(recipeId, s, itemstack, (NonNullList<Ingredient>)inputs);
        }

        public void write(PacketBuffer buffer, FarmlandTillRecipe recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

