/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.api.crop.ICropGetter;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.item.ModItems;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;

public class MysticalCropBlock
extends CropsBlock
implements ICropGetter {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private final ICrop crop;

    public MysticalCropBlock(ICrop crop) {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150464_aj));
        this.crop = crop;
    }

    protected IItemProvider func_199772_f() {
        return this.crop.getSeeds();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return false;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_177230_c() instanceof FarmlandBlock;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        Block block;
        Block crux = this.crop.getCrux();
        if (crux != null && (block = world.func_180495_p(pos.func_177979_c(2)).func_177230_c()) != crux) {
            return;
        }
        super.func_225534_a_(state, world, pos, random);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        int age = (Integer)state.func_177229_b((IProperty)field_176488_a);
        int crop = 0;
        int seed = 1;
        int fertilizer = 0;
        if (age == this.func_185526_g()) {
            crop = 1;
            BlockPos pos = (BlockPos)builder.func_216019_b(LootParameters.field_216286_f);
            if (pos != null) {
                ServerWorld world = builder.func_216018_a();
                Block below = world.func_180495_p(pos.func_177977_b()).func_177230_c();
                double chance = this.crop.getSecondaryChance(below);
                if (world.func_201674_k().nextDouble() < chance) {
                    crop = 2;
                }
                if (world.func_201674_k().nextDouble() < chance) {
                    seed = 2;
                }
                Double fertilizerChance = (Double)ModConfigs.FERTILIZED_ESSENCE_DROP_CHANCE.get();
                if (world.func_201674_k().nextDouble() < fertilizerChance) {
                    fertilizer = 1;
                }
            }
        }
        List drops = super.func_220076_a(state, builder);
        if (crop > 0) {
            drops.add(new ItemStack(this.getCropsItem(), crop));
        }
        drops.add(new ItemStack(this.func_199772_f(), seed));
        if (fertilizer > 0) {
            drops.add(new ItemStack((IItemProvider)ModItems.FERTILIZED_ESSENCE.get()));
        }
        return drops;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        Block block;
        Block crux = this.crop.getCrux();
        if (crux != null && (block = world.func_180495_p(pos.func_177979_c(2)).func_177230_c()) != crux) {
            return;
        }
        super.func_225535_a_(world, rand, pos, state);
    }

    @Override
    public ICrop getCrop() {
        return this.crop;
    }

    protected IItemProvider getCropsItem() {
        return this.crop.getEssence();
    }
}

