/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mods.waterstrainer.registry.FileRegistry;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncLootTable {
    private List<String> lootTableData = new ArrayList<String>();
    private int lootTableSize = 0;

    public PacketSyncLootTable(List<String> data) {
        this.lootTableSize = data == null ? 0 : data.size();
        this.lootTableData = data;
    }

    public static void writePacket(PacketSyncLootTable packet, PacketBuffer buf) {
        buf.writeInt(packet.lootTableSize);
        if (packet.lootTableSize > 0) {
            for (String data : packet.lootTableData) {
                buf.func_180714_a(data);
            }
        }
    }

    public static PacketSyncLootTable readPacket(PacketBuffer buf) {
        int length = buf.readInt();
        ArrayList<String> list = new ArrayList<String>();
        if (length > 0) {
            for (int i = 1; i <= length; ++i) {
                list.add(buf.func_150789_c(Short.MAX_VALUE));
            }
        }
        return new PacketSyncLootTable(list);
    }

    public static class Handler {
        public static void handlePacket(PacketSyncLootTable packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> FileRegistry.LOOTTABLE.parseData(packet.lootTableData));
            ctx.get().setPacketHandled(true);
        }
    }
}

