/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.utils;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import vswe.stevesfactory.api.StevesFactoryManagerAPI;
import vswe.stevesfactory.api.logic.Connection;
import vswe.stevesfactory.api.logic.IExecutionContext;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.api.logic.IProcedureType;
import vswe.stevesfactory.api.network.ICable;
import vswe.stevesfactory.api.network.IConnectable;
import vswe.stevesfactory.api.network.INetworkController;
import vswe.stevesfactory.utils.Utils;

public final class NetworkHelper {
    private NetworkHelper() {
    }

    public static <P extends IProcedure> P fabricateInstance(INetworkController controller, IProcedureType<P> type) {
        P p = type.createInstance();
        controller.getPGraph().addProcedure((IProcedure)p);
        return p;
    }

    public static IProcedure retrieveProcedureAndAdd(INetworkController controller, CompoundNBT tag) {
        Object p = NetworkHelper.findTypeFor(tag).retrieveInstance(tag);
        controller.getPGraph().addProcedure((IProcedure)p);
        return p;
    }

    public static IProcedureType<?> findTypeFor(CompoundNBT tag) {
        ResourceLocation id = new ResourceLocation(tag.func_74779_i("ID"));
        return NetworkHelper.findTypeFor(id);
    }

    public static IProcedureType<?> findTypeFor(ResourceLocation id) {
        IProcedureType p = (IProcedureType)StevesFactoryManagerAPI.getProceduresRegistry().getValue(id);
        Preconditions.checkArgument((p != null ? 1 : 0) != 0, (Object)("Unable to find a procedure registered as " + id + "!"));
        return p;
    }

    public static <P extends IProcedure> Function<INetworkController, P> wrapConstructor(Supplier<P> constructor) {
        return controller -> {
            IProcedure p = (IProcedure)constructor.get();
            controller.getPGraph().addProcedure(p);
            return p;
        };
    }

    public static void removeAllConnectionsFor(IProcedure procedure) {
        if (!procedure.isValid()) {
            return;
        }
        for (Connection conn : procedure.predecessors()) {
            if (conn == null) continue;
            conn.remove();
        }
        for (Connection conn : procedure.successors()) {
            if (conn == null) continue;
            conn.remove();
        }
    }

    public static void removeAllConnected(IProcedure start) {
        HashSet<IProcedure> visited = new HashSet<IProcedure>();
        ArrayDeque<IProcedure> nexts = new ArrayDeque<IProcedure>();
        nexts.add(start);
        while (!nexts.isEmpty()) {
            IProcedure node = (IProcedure)nexts.remove();
            for (Connection conn : node.predecessors()) {
                IProcedure source = conn.getSource();
                if (visited.contains(source)) continue;
                visited.add(source);
                nexts.add(source);
            }
            for (Connection conn : node.successors()) {
                IProcedure dest = conn.getDestination();
                if (visited.contains(dest)) continue;
                visited.add(dest);
                nexts.add(dest);
            }
        }
        for (IProcedure procedure : visited) {
            procedure.invalidate();
        }
    }

    public static IConnectable.LinkType getLinkType(@Nullable TileEntity tile) {
        if (tile instanceof IConnectable) {
            return ((IConnectable)tile).getConnectionType();
        }
        return IConnectable.LinkType.DEFAULT;
    }

    public static void updateLinksFor(INetworkController controller, ICable cable) {
        for (Capability<?> cap : StevesFactoryManagerAPI.getRecognizableCapabilities()) {
            NetworkHelper.updateLinksFor(controller, cable, cap);
        }
    }

    public static void updateLinksFor(INetworkController controller, ICable cable, Capability<?> cap) {
        World world = controller.getControllerWorld();
        for (BlockPos neighbor : Utils.neighbors(cable.getPosition())) {
            TileEntity tile = world.func_175625_s(neighbor);
            if (tile == null) continue;
            switch (NetworkHelper.getLinkType(tile)) {
                case ALWAYS: {
                    if (Utils.hasCapabilityAtAll((ICapabilityProvider)tile, cap)) {
                        controller.addLink(cap, neighbor);
                        break;
                    }
                    controller.addLink(IConnectable.UNKNOWN_CONNECTION_CAPABILITY, neighbor);
                    break;
                }
                case DEFAULT: {
                    if (!Utils.hasCapabilityAtAll((ICapabilityProvider)tile, cap)) break;
                    controller.addLink(cap, neighbor);
                    break;
                }
            }
        }
    }

    public static <T> T obtainCustomData(IExecutionContext context, Class<T> type, Supplier<T> factory) {
        Object res = context.getCustomData().get(type);
        if (res == null) {
            res = factory.get();
            context.getCustomData().putInstance(type, res);
        }
        return (T)res;
    }

    public static <T> void cacheDirectionalCaps(IExecutionContext context, Collection<LazyOptional<T>> target, Collection<BlockPos> poses, Collection<Direction> directions, Capability<T> type, @Nullable NonNullConsumer<LazyOptional<T>> listener) {
        NetworkHelper.cacheDirectionalCaps(context, context.getController().getLinkedInventories(type), target, poses, directions, type, listener);
    }

    public static <T> void cacheDirectionalCaps(IExecutionContext context, Set<BlockPos> linkedInventories, Collection<LazyOptional<T>> target, Collection<BlockPos> poses, Collection<Direction> directions, Capability<T> type, @Nullable NonNullConsumer<LazyOptional<T>> listener) {
        for (BlockPos pos : poses) {
            TileEntity tile;
            if (!linkedInventories.contains(pos) || (tile = context.getControllerWorld().func_175625_s(pos)) == null) continue;
            for (Direction direction : directions) {
                LazyOptional cap = tile.getCapability(type, direction);
                if (!cap.isPresent()) continue;
                target.add(cap);
                if (listener == null) continue;
                cap.addListener(listener);
            }
        }
    }

    public static <T> void cacheCaps(IExecutionContext context, Collection<LazyOptional<T>> target, Collection<BlockPos> poses, Capability<T> capability, @Nullable NonNullConsumer<LazyOptional<T>> listener) {
        NetworkHelper.cacheCaps(context, context.getController().getLinkedInventories(capability), target, poses, capability, listener);
    }

    public static <T> void cacheCaps(IExecutionContext context, Set<BlockPos> linkedInventories, Collection<LazyOptional<T>> target, Collection<BlockPos> poses, Capability<T> capability, @Nullable NonNullConsumer<LazyOptional<T>> listener) {
        for (BlockPos pos : poses) {
            LazyOptional cap;
            TileEntity tile;
            if (!linkedInventories.contains(pos) || (tile = context.getControllerWorld().func_175625_s(pos)) == null || !(cap = tile.getCapability(capability)).isPresent()) continue;
            target.add(cap);
            if (listener == null) continue;
            cap.addListener(listener);
        }
    }
}

