/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.tool.group;

import java.util.Collection;
import java.util.HashSet;
import vswe.stevesfactory.api.logic.IClientDataStorage;
import vswe.stevesfactory.library.gui.widget.box.LinearList;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.tool.group.GroupButton;

public class GroupList
extends LinearList<GroupButton> {
    public GroupList() {
        super(64, 0);
        this.onProcedureGroupChanged();
    }

    public GroupList addChildren(GroupButton widget) {
        super.addChildren(widget);
        widget.setWidth(this.calcButtonWidth());
        return this;
    }

    public GroupList addChildren(Collection<GroupButton> widgets) {
        super.addChildren(widgets);
        for (GroupButton widget : widgets) {
            widget.setWidth(this.calcButtonWidth());
        }
        return this;
    }

    private int calcButtonWidth() {
        return this.getBarLeft() - 2;
    }

    @Override
    public int getMarginMiddle() {
        return 2;
    }

    public void onProcedureGroupChanged() {
        this.getChildren().clear();
        HashSet<String> existing = new HashSet<String>();
        existing.add("");
        this.addChildren(new GroupButton(""));
        for (FlowComponent<?> component : FactoryManagerGUI.getActiveGUI().getTopLevel().editorPanel.getFlowComponents()) {
            String group = component.getGroup();
            if (existing.contains(group)) continue;
            existing.add(group);
            GroupButton btn = new GroupButton(group);
            this.addChildren(btn);
        }
        this.reflow();
    }

    public void delete(String withGroup) {
        FactoryManagerGUI gui = FactoryManagerGUI.getActiveGUI();
        for (FlowComponent<?> component : gui.getTopLevel().editorPanel.getFlowComponents()) {
            if (!component.getGroup().equals(withGroup)) continue;
            gui.scheduleTask(w -> component.remove());
        }
    }

    public void move(String withGroup, String toGroup) {
        for (FlowComponent<?> component : FactoryManagerGUI.getActiveGUI().getTopLevel().editorPanel.getFlowComponents()) {
            if (!component.getGroup().equals(withGroup)) continue;
            ((IClientDataStorage)component.getProcedure()).setGroup(toGroup);
        }
    }
}

