/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic.procedure;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import vswe.stevesfactory.api.capability.CapabilityEventDispatchers;
import vswe.stevesfactory.api.capability.IRedstoneEventDispatcher;
import vswe.stevesfactory.api.logic.Connection;
import vswe.stevesfactory.api.logic.IExecutionContext;
import vswe.stevesfactory.api.logic.ITrigger;
import vswe.stevesfactory.api.network.INetworkController;
import vswe.stevesfactory.logic.AbstractProcedure;
import vswe.stevesfactory.logic.ModProcedures;
import vswe.stevesfactory.logic.execution.ProcedureExecutor;
import vswe.stevesfactory.logic.procedure.IAnalogTarget;
import vswe.stevesfactory.logic.procedure.IDirectionTarget;
import vswe.stevesfactory.logic.procedure.IInventoryTarget;
import vswe.stevesfactory.logic.procedure.ILogicalConjunction;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.menu.InventorySelectionMenu;
import vswe.stevesfactory.ui.manager.menu.RedstoneSidesMenu;
import vswe.stevesfactory.ui.manager.menu.RedstoneStrengthMenu;
import vswe.stevesfactory.utils.IOHelper;
import vswe.stevesfactory.utils.Utils;

public class RedstoneTriggerProcedure
extends AbstractProcedure
implements ITrigger,
IInventoryTarget,
IDirectionTarget,
ILogicalConjunction,
IAnalogTarget {
    public static final int WATCHING = 0;
    public static final int DIRECTIONS = 0;
    public static final int RISING_EDGE_CHILD = 0;
    public static final int FALLING_EDGE_CHILD = 1;
    private List<BlockPos> watchingSources = new ArrayList<BlockPos>();
    private Set<Direction> directions = EnumSet.allOf(Direction.class);
    private ILogicalConjunction.Type conjunction = ILogicalConjunction.Type.ANY;
    private int analogBegin = 1;
    private int analogEnd = 15;
    private boolean invertAnalog = false;
    private transient boolean dirty = true;

    public RedstoneTriggerProcedure() {
        super(ModProcedures.redstoneTrigger, 0, 2);
    }

    @Override
    public void execute(IExecutionContext context) {
        this.pushFrame(context, 0);
    }

    @Override
    public void tick(INetworkController controller) {
        if (!this.dirty && this.isValid()) {
            return;
        }
        World world = controller.getControllerWorld();
        for (BlockPos watching : this.watchingSources) {
            LazyOptional cap;
            TileEntity tile = world.func_175625_s(watching);
            if (tile == null || !(cap = tile.getCapability(CapabilityEventDispatchers.REDSTONE_EVENT_DISPATCHER_CAPABILITY)).isPresent()) continue;
            IRedstoneEventDispatcher dispatcher = (IRedstoneEventDispatcher)cap.orElseThrow(RuntimeException::new);
            BooleanHolder last = new BooleanHolder(dispatcher.hasSignal());
            dispatcher.subscribe(status -> {
                if (!this.isValid()) {
                    return true;
                }
                boolean current = this.applyConjunction((IRedstoneEventDispatcher.SignalStatus)status);
                if (current != last.value) {
                    Connection connection = this.successors()[current ? 0 : 1];
                    if (connection != null) {
                        new ProcedureExecutor(controller, world).start(connection.getDestination());
                    }
                    last.value = current;
                }
                return false;
            });
        }
        this.dirty = false;
    }

    private boolean applyConjunction(IRedstoneEventDispatcher.SignalStatus status) {
        boolean result = this.conjunction == ILogicalConjunction.Type.ALL;
        for (Direction direction : this.directions) {
            int power = status.get(direction);
            result = this.conjunction.combine(result, this.applyAnalog(power));
        }
        return result;
    }

    private boolean applyAnalog(int power) {
        return Utils.invertIf(power >= this.analogBegin && power <= this.analogEnd, this.invertAnalog);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FlowComponent<RedstoneTriggerProcedure> createFlowComponent() {
        FlowComponent<RedstoneTriggerProcedure> f = FlowComponent.of(this);
        f.addMenu(new InventorySelectionMenu(0, I18n.func_135052_a((String)"menu.sfm.RedstoneTrigger.Watches", (Object[])new Object[0]), I18n.func_135052_a((String)"error.sfm.RedstoneTrigger.NoWatches", (Object[])new Object[0]), CapabilityEventDispatchers.REDSTONE_EVENT_DISPATCHER_CAPABILITY));
        f.addMenu(new RedstoneSidesMenu(0, () -> this.conjunction == ILogicalConjunction.Type.ANY, () -> {
            this.conjunction = ILogicalConjunction.Type.ANY;
        }, I18n.func_135052_a((String)"menu.sfm.IfAny", (Object[])new Object[0]), () -> this.conjunction == ILogicalConjunction.Type.ALL, () -> {
            this.conjunction = ILogicalConjunction.Type.ALL;
        }, I18n.func_135052_a((String)"menu.sfm.RequireAll", (Object[])new Object[0]), I18n.func_135052_a((String)"menu.sfm.RedstoneTrigger.Sides", (Object[])new Object[0]), I18n.func_135052_a((String)"menu.sfm.RedstoneTrigger.Sides.Info", (Object[])new Object[0])));
        f.addMenu(new RedstoneStrengthMenu());
        return f;
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT tag = super.serialize();
        tag.func_218657_a("Watching", (INBT)IOHelper.writeBlockPoses(this.watchingSources));
        tag.func_74783_a("Directions", IOHelper.direction2Index(this.directions));
        tag.func_74768_a("ConjunctionType", this.conjunction.ordinal());
        tag.func_74768_a("AnalogBegin", this.analogBegin);
        tag.func_74768_a("AnalogEnd", this.analogEnd);
        tag.func_74757_a("InvertAnalog", this.invertAnalog);
        return tag;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.watchingSources = IOHelper.readBlockPoses(tag.func_150295_c("Watching", 10), new ArrayList());
        this.directions = IOHelper.index2DirectionFill(tag.func_74759_k("Directions"), EnumSet.noneOf(Direction.class));
        this.conjunction = ILogicalConjunction.Type.VALUES[tag.func_74762_e("ConjunctionType")];
        this.analogBegin = tag.func_74762_e("AnalogBegin");
        this.analogEnd = tag.func_74762_e("AnalogEnd");
        this.invertAnalog = tag.func_74767_n("InvertCondition");
        this.markDirty();
    }

    @Override
    public List<BlockPos> getInventories(int id) {
        return this.watchingSources;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public Set<Direction> getDirections(int id) {
        return this.directions;
    }

    @Override
    public ILogicalConjunction.Type getConjunction() {
        return this.conjunction;
    }

    @Override
    public void setConjunction(ILogicalConjunction.Type type) {
        this.conjunction = type;
    }

    @Override
    public int getAnalogBegin() {
        return this.analogBegin;
    }

    @Override
    public void setAnalogBegin(int analogBegin) {
        this.analogBegin = analogBegin;
    }

    @Override
    public int getAnalogEnd() {
        return this.analogEnd;
    }

    @Override
    public void setAnalogEnd(int analogEnd) {
        this.analogEnd = analogEnd;
    }

    @Override
    public boolean isInverted() {
        return this.invertAnalog;
    }

    @Override
    public void setInverted(boolean inverted) {
        this.invertAnalog = inverted;
    }

    private static final class BooleanHolder {
        public boolean value;

        public BooleanHolder(boolean value) {
            this.value = value;
        }
    }
}

