/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import vswe.stevesfactory.api.capability.CapabilityRedstone;
import vswe.stevesfactory.api.capability.IRedstoneHandler;
import vswe.stevesfactory.blocks.RedstoneEmitterTileEntity;

public class RedstoneEmitterBlock
extends Block {
    public static final EnumProperty<IRedstoneHandler.Type> TYPE_PROPERTY = EnumProperty.func_177709_a((String)"type", IRedstoneHandler.Type.class);

    public RedstoneEmitterBlock(Block.Properties properties) {
        super(properties);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new IProperty[]{TYPE_PROPERTY});
    }

    public int func_180656_a(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        return this.getPowerInternal(world, pos, side, false);
    }

    public int func_176211_b(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        return this.getPowerInternal(world, pos, side, true);
    }

    private int getPowerInternal(IBlockReader world, BlockPos pos, Direction side, boolean forceStrong) {
        RedstoneEmitterTileEntity emitter;
        LazyOptional<IRedstoneHandler> cap;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof RedstoneEmitterTileEntity && (cap = (emitter = (RedstoneEmitterTileEntity)tile).getCapability(CapabilityRedstone.REDSTONE_CAPABILITY, side)).isPresent()) {
            IRedstoneHandler redstone = (IRedstoneHandler)cap.orElseThrow(RuntimeException::new);
            return forceStrong && redstone.isWeak() ? 0 : redstone.getSignal();
        }
        return 0;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new RedstoneEmitterTileEntity();
    }
}

