/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import vswe.stevesfactory.StevesFactoryManager;

public final class Config {
    public static final CommonCategory COMMON;
    public static final ClientCategory CLIENT;
    static final ForgeConfigSpec COMMON_SPEC;
    static final ForgeConfigSpec CLIENT_SPEC;

    private Config() {
    }

    static void onLoad(ModConfig.Loading event) {
        StevesFactoryManager.logger.debug("Loaded {} config file {}", (Object)"sfm", (Object)event.getConfig().getFileName());
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        COMMON = new CommonCategory(builder);
        COMMON_SPEC = builder.build();
        builder = new ForgeConfigSpec.Builder();
        CLIENT = new ClientCategory(builder);
        CLIENT_SPEC = builder.build();
    }

    public static final class ClientCategory {
        public final ForgeConfigSpec.BooleanValue showComponentGroupsMessage;
        public final ForgeConfigSpec.IntValue scrollSpeed;
        public final ForgeConfigSpec.BooleanValue enableInspections;
        public final ForgeConfigSpec.BooleanValue useFixedSizeScreen;
        public final ForgeConfigSpec.BooleanValue useBackgroundOnFullscreen;
        public final ForgeConfigSpec.IntValue defaultEditorMoveSpeed;
        public final ForgeConfigSpec.IntValue acceleratedEditorMoveSpeed;

        private ClientCategory(ForgeConfigSpec.Builder builder) {
            builder.comment("General client config options").push("general");
            this.showComponentGroupsMessage = builder.comment("Controls whether the to hint the player to reload component groups on login or not").define("showComponentGroupsMessage", true);
            builder.pop();
            builder.comment("General GUI config options").push("generalGUI");
            this.scrollSpeed = builder.comment("How long one move wheel movement for scrolling lists").defineInRange("scrollSpeed", 20, 1, 256);
            this.enableInspections = builder.comment("Set to true to enable debug highlighting for GUIs").define("enableInspections", false);
            builder.pop();
            builder.comment("Factory manager GUI config options").push("factoryManagerGUI");
            this.useFixedSizeScreen = builder.comment(new String[]{"Enable to fix the factory manager size at 256*140, ", "otherwise it will be 2/3 of the window width, and 3/4 of the window height"}).define("useFixedSizeScreen", false);
            this.useBackgroundOnFullscreen = builder.comment("Enable to use vanilla background instead of a plain rectangle").define("useBackgroundOnFullscreen", false);
            this.defaultEditorMoveSpeed = builder.comment("Determines how fast arrow keys moving is (for editor panel)").defineInRange("defaultEditorMoveSpeed", 2, 0, Integer.MAX_VALUE);
            this.acceleratedEditorMoveSpeed = builder.comment("Determines how fast arrow keys moving is, while Shift is pressed").defineInRange("acceleratedEditorMoveSpeed", 20, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static final class CommonCategory {
        public final ForgeConfigSpec.IntValue maxSearchDepth;
        public final ForgeConfigSpec.IntValue rescanInterval;
        public final ForgeConfigSpec.IntValue repeatThreshold;
        public final ForgeConfigSpec.IntValue regularPickupInterval;
        public final ForgeConfigSpec.IntValue instantPickupInterval;
        public final ForgeConfigSpec.IntValue regularMaxRadius;
        public final ForgeConfigSpec.IntValue instantMaxRadius;
        public final ForgeConfigSpec.IntValue regularInventorySize;
        public final ForgeConfigSpec.IntValue instantInventorySize;
        public final ForgeConfigSpec.BooleanValue isRedstoneInputBlockCables;
        public final ForgeConfigSpec.BooleanValue isRedstoneEmitterBlockCables;
        public final ForgeConfigSpec.BooleanValue isBUDBlockCables;
        public final ForgeConfigSpec.BooleanValue isItemIntakeBlockCables;
        public final ForgeConfigSpec.BooleanValue isInstantItemIntakeBlockCables;
        public final ForgeConfigSpec.BooleanValue enableIntervalTrigger;
        public final ForgeConfigSpec.BooleanValue enableRedstoneTrigger;
        public final ForgeConfigSpec.BooleanValue enableBUDTrigger;
        public final ForgeConfigSpec.BooleanValue enableItemTransfer;
        public final ForgeConfigSpec.BooleanValue enableItemImport;
        public final ForgeConfigSpec.BooleanValue enableItemExport;
        public final ForgeConfigSpec.BooleanValue enableCrafting;
        public final ForgeConfigSpec.BooleanValue enableFluidTransfer;
        public final ForgeConfigSpec.BooleanValue enableRedstoneEmitter;
        public final ForgeConfigSpec.BooleanValue enableSignUpdater;
        public final ForgeConfigSpec.BooleanValue enableSequentialBranch;
        public final ForgeConfigSpec.BooleanValue enableMergeBranch;
        public final ForgeConfigSpec.BooleanValue enableFunctionHat;
        public final ForgeConfigSpec.BooleanValue enableFunctionInvoke;

        private CommonCategory(ForgeConfigSpec.Builder builder) {
            builder.comment("Factory manager config options").push("factoryManager");
            this.maxSearchDepth = builder.comment("Maximum depth that the Factory Manager DFS algorithm should go").defineInRange("maxSearchDepth", 64, 0, Integer.MAX_VALUE);
            this.rescanInterval = builder.comment("Number of ticks for the Factory Manager to rescan the network. Set to -1 to make it never rescan passively").defineInRange("rescanInterval", 100, -1, Integer.MAX_VALUE);
            this.repeatThreshold = builder.comment(new String[]{"Maximum number that the controller is allowed executes a single procedure in one execution pass", "Extra attempts to the procedure will be ignored, and it's connection chain will stop"}).defineInRange("repeatThreshold", 8, 1, 64);
            builder.pop();
            builder.comment("Item intake config options").push("itemIntake");
            this.regularPickupInterval = builder.comment("Interval between each pickup attempt for regular item intake, in ticks").defineInRange("regularPickupInterval", 80, 0, Integer.MAX_VALUE);
            this.instantPickupInterval = builder.comment("Interval between each pickup attempt for instant item intake, in ticks").defineInRange("instantPickupInterval", 80, 0, Integer.MAX_VALUE);
            this.regularMaxRadius = builder.comment("Maximum pickup radius that an item take can have, for regular item intake").defineInRange("regularMaxPickupDistance", 3, 0, Integer.MAX_VALUE);
            this.instantMaxRadius = builder.comment("Maximum pickup radius that an item take can have, for instant item intake").defineInRange("instantMaxPickupDistance", 3, 0, Integer.MAX_VALUE);
            this.regularInventorySize = builder.comment("Internal inventory size for item intakes").defineInRange("regularInventorySize", 5, 1, 27);
            this.instantInventorySize = builder.comment("Internal inventory size for instant item intakes").defineInRange("instantInventorySize", 5, 0, 27);
            builder.pop();
            builder.comment("Block property config options").push("blocks");
            this.isRedstoneInputBlockCables = builder.comment("Whether the redstone input block (sfm:redstone_input) is considered a cable").define("isRedstoneInputBlockCables", false);
            this.isRedstoneEmitterBlockCables = builder.comment("Whether the redstone emitter block (sfm:redstone_emitter) is considered a cable").define("isRedstoneEmitterBlockCables", false);
            this.isBUDBlockCables = builder.comment("Whether the block detector (sfm:bud) is considered a cable").define("isBUDBlockCables", false);
            this.isItemIntakeBlockCables = builder.comment("Whether the item intake block (sfm:item_intake) is considered a cable").define("isItemIntakeBlockCables", false);
            this.isInstantItemIntakeBlockCables = builder.comment("Whether the instant item intake block (sfm:instant_item_intake) is considered a cable").define("isInstantItemIntakeBlockCables", false);
            builder.pop();
            builder.comment(new String[]{"Procedures config options", "Run '/sfm componentGroups reload' after updating config"}).push("procedures");
            this.enableIntervalTrigger = builder.define("enableIntervalTrigger", true);
            this.enableRedstoneTrigger = builder.define("enableRedstoneTrigger", true);
            this.enableBUDTrigger = builder.define("enableBUDTrigger", true);
            this.enableItemTransfer = builder.define("enableItemTransfer", true);
            this.enableItemImport = builder.define("enableItemImport", true);
            this.enableItemExport = builder.define("enableItemExport", true);
            this.enableCrafting = builder.define("enableCrafting", true);
            this.enableFluidTransfer = builder.define("enableFluidTransfer", true);
            this.enableRedstoneEmitter = builder.define("enableRedstoneEmitter", true);
            this.enableSignUpdater = builder.define("enableSignUpdater", true);
            this.enableSequentialBranch = builder.define("enableSequentialBranch", true);
            this.enableMergeBranch = builder.define("enableMergeBranch", true);
            this.enableFunctionHat = builder.define("enableFunctionHat", true);
            this.enableFunctionInvoke = builder.define("enableFunctionInvoke", true);
            builder.pop();
        }
    }
}

