/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import tk.zeitheron.solarflux.SolarFlux;
import tk.zeitheron.solarflux.items.ItemsSF;
import tk.zeitheron.solarflux.panels.SolarPanel;
import tk.zeitheron.solarflux.panels.SolarPanels;
import tk.zeitheron.solarflux.shaded.hammerlib.api.OreDict;

@Mod.EventBusSubscriber
public class RecipesSF {
    static int lastRecipeID;

    public static void addRecipes(List<IRecipe<?>> r) {
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)ItemsSF.MIRROR, 3), "ggg", " i ", Character.valueOf('g'), "blockGlass", Character.valueOf('i'), "ingotIron"));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)ItemsSF.PHOTOVOLTAIC_CELL_1), "ggg", "lll", "mmm", Character.valueOf('g'), "blockGlass", Character.valueOf('l'), "gemLapis", Character.valueOf('m'), ItemsSF.MIRROR));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)ItemsSF.PHOTOVOLTAIC_CELL_2), "clc", "lcl", "msm", Character.valueOf('c'), Items.field_151119_aD, Character.valueOf('l'), "gemLapis", Character.valueOf('m'), ItemsSF.MIRROR, Character.valueOf('s'), ItemsSF.PHOTOVOLTAIC_CELL_1));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)ItemsSF.PHOTOVOLTAIC_CELL_3), "ggg", "lll", "oco", Character.valueOf('g'), "blockGlass", Character.valueOf('l'), "dustGlowstone", Character.valueOf('o'), "obsidian", Character.valueOf('c'), ItemsSF.PHOTOVOLTAIC_CELL_2));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)ItemsSF.PHOTOVOLTAIC_CELL_4), "bbb", "gdg", "qcq", Character.valueOf('b'), Items.field_151065_br, Character.valueOf('g'), "dustGlowstone", Character.valueOf('d'), "gemDiamond", Character.valueOf('q'), "blockQuartz", Character.valueOf('c'), ItemsSF.PHOTOVOLTAIC_CELL_3));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)ItemsSF.PHOTOVOLTAIC_CELL_5), "bbb", "gdg", "qcq", Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('g'), Blocks.field_150426_aN, Character.valueOf('d'), "blockDiamond", Character.valueOf('q'), "blockQuartz", Character.valueOf('c'), new ItemStack((IItemProvider)ItemsSF.PHOTOVOLTAIC_CELL_4)));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)ItemsSF.PHOTOVOLTAIC_CELL_6), "bbb", "gdg", "qcq", Character.valueOf('b'), "gemEmerald", Character.valueOf('g'), Blocks.field_150426_aN, Character.valueOf('d'), "blockDiamond", Character.valueOf('q'), "blockQuartz", Character.valueOf('c'), new ItemStack((IItemProvider)ItemsSF.PHOTOVOLTAIC_CELL_5)));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)ItemsSF.BLANK_UPGRADE), " c ", "cmc", " c ", Character.valueOf('c'), "cobblestone", Character.valueOf('m'), ItemsSF.MIRROR));
        Item dragon_egg = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "dragon_egg"));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)SolarPanels.CORE_PANELS[0].getBlock()), "mmm", "prp", "ppp", Character.valueOf('m'), ItemsSF.MIRROR, Character.valueOf('p'), "plankWood", Character.valueOf('r'), "dustRedstone"));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)SolarPanels.CORE_PANELS[1].getBlock()), "sss", "sps", "sss", Character.valueOf('s'), SolarPanels.getGeneratingSolars(SolarPanels.CORE_PANELS[0].delegateData.generation), Character.valueOf('p'), Blocks.field_150331_J));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)SolarPanels.CORE_PANELS[2].getBlock(), 2), "ppp", "scs", "sbs", Character.valueOf('s'), SolarPanels.getGeneratingSolars(SolarPanels.CORE_PANELS[1].delegateData.generation), Character.valueOf('p'), ItemsSF.PHOTOVOLTAIC_CELL_1, Character.valueOf('c'), Items.field_222027_iT, Character.valueOf('b'), "blockIron"));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)SolarPanels.CORE_PANELS[3].getBlock(), 2), "ppp", "scs", "sbs", Character.valueOf('s'), SolarPanels.getGeneratingSolars(SolarPanels.CORE_PANELS[2].delegateData.generation), Character.valueOf('p'), ItemsSF.PHOTOVOLTAIC_CELL_2, Character.valueOf('c'), Items.field_151113_aN, Character.valueOf('b'), "blockIron"));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)SolarPanels.CORE_PANELS[4].getBlock(), 2), "ppp", "scs", "sbs", Character.valueOf('s'), SolarPanels.getGeneratingSolars(SolarPanels.CORE_PANELS[3].delegateData.generation), Character.valueOf('p'), ItemsSF.PHOTOVOLTAIC_CELL_3, Character.valueOf('c'), "dustGlowstone", Character.valueOf('b'), "blockGold"));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)SolarPanels.CORE_PANELS[5].getBlock(), 2), "ppp", "scs", "sbs", Character.valueOf('s'), SolarPanels.getGeneratingSolars(SolarPanels.CORE_PANELS[4].delegateData.generation), Character.valueOf('p'), ItemsSF.PHOTOVOLTAIC_CELL_4, Character.valueOf('c'), Blocks.field_150379_bu, Character.valueOf('b'), "blockDiamond"));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)SolarPanels.CORE_PANELS[6].getBlock(), 2), "ppp", "scs", "scs", Character.valueOf('s'), SolarPanels.getGeneratingSolars(SolarPanels.CORE_PANELS[5].delegateData.generation), Character.valueOf('p'), ItemsSF.PHOTOVOLTAIC_CELL_5, Character.valueOf('c'), new ItemStack((IItemProvider)Items.field_185157_bK)));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)SolarPanels.CORE_PANELS[7].getBlock(), 2), "ppp", "scs", "scs", Character.valueOf('s'), SolarPanels.getGeneratingSolars(SolarPanels.CORE_PANELS[6].delegateData.generation), Character.valueOf('p'), ItemsSF.PHOTOVOLTAIC_CELL_6, Character.valueOf('c'), new ItemStack((IItemProvider)dragon_egg)));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)ItemsSF.EFFICIENCY_UPGRADE), " m ", "mum", " c ", Character.valueOf('m'), ItemsSF.MIRROR, Character.valueOf('u'), ItemsSF.BLANK_UPGRADE, Character.valueOf('c'), ItemsSF.PHOTOVOLTAIC_CELL_1));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)ItemsSF.TRANSFER_RATE_UPGRADE), "rrr", "gug", "rrr", Character.valueOf('u'), ItemsSF.BLANK_UPGRADE, Character.valueOf('r'), "dustRedstone", Character.valueOf('g'), "ingotGold"));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)ItemsSF.TRAVERSAL_UPGRADE), "ipi", "rur", "ipi", Character.valueOf('i'), "ingotIron", Character.valueOf('p'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150331_J, Blocks.field_150320_F}), Character.valueOf('u'), ItemsSF.BLANK_UPGRADE, Character.valueOf('r'), "dustRedstone"));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)ItemsSF.DISPERSIVE_UPGRADE), "geg", "eue", "geg", Character.valueOf('g'), "dustGlowstone", Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('u'), ItemsSF.BLANK_UPGRADE));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)ItemsSF.BLOCK_CHARGING_UPGRADE), "geg", "eue", "geg", Character.valueOf('g'), "enderpearl", Character.valueOf('e'), "blockRedstone", Character.valueOf('u'), ItemsSF.DISPERSIVE_UPGRADE));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)ItemsSF.FURNACE_UPGRADE), "ccc", "cuc", "cfc", Character.valueOf('u'), ItemsSF.BLANK_UPGRADE, Character.valueOf('c'), Items.field_151044_h, Character.valueOf('f'), Blocks.field_150460_al));
        r.add((IRecipe<?>)RecipesSF.parseShaped(new ItemStack((IItemProvider)ItemsSF.CAPACITY_UPGRADE), " r ", "rur", "rcr", Character.valueOf('u'), ItemsSF.BLANK_UPGRADE, Character.valueOf('r'), "dustRedstone", Character.valueOf('c'), "blockDiamond"));
        SolarPanels.listPanels().flatMap(SolarPanel::recipes).forEach(r::add);
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            RecipeManager mgr = e.world.func_199532_z();
            Field f = RecipeManager.class.getDeclaredFields()[2];
            f.setAccessible(true);
            try {
                HashMap recipes = (HashMap)Map.class.cast(f.get(mgr));
                if (recipes instanceof ImmutableMap) {
                    recipes = new HashMap(recipes);
                    f.set(mgr, recipes);
                }
                if (!recipes.containsKey(SFRRecipeType.INSTANCE)) {
                    RecipesSF.addRecipes(recipes);
                    recipes.put(SFRRecipeType.INSTANCE, new HashMap());
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void addRecipes(Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> recipes) {
        ArrayList shaped = new ArrayList();
        RecipesSF.addRecipes(shaped);
        shaped.forEach(recipe -> {
            IRecipeType type = recipe.func_222127_g();
            HashMap<ResourceLocation, IRecipe> map = (HashMap<ResourceLocation, IRecipe>)recipes.get(type);
            if (map instanceof ImmutableMap) {
                map = new HashMap<ResourceLocation, IRecipe>(map);
                recipes.put(type, map);
            }
            map.put(recipe.func_199560_c(), (IRecipe)recipe);
        });
    }

    private static ResourceLocation nextId(Item item) {
        ResourceLocation rl = item.getRegistryName();
        return new ResourceLocation(rl.func_110624_b(), ++lastRecipeID + "/" + rl.func_110623_a());
    }

    public static ShapedRecipe parseShaped(ItemStack output, Object ... recipeComponents) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (recipeComponents[i] instanceof String[]) {
            String[] astring;
            for (String s2 : astring = (String[])recipeComponents[i++]) {
                ++k;
                j = s2.length();
                s = s + s2;
            }
        } else {
            while (recipeComponents[i] instanceof String) {
                String s1 = (String)recipeComponents[i++];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        }
        HashMap map = Maps.newHashMap();
        while (i < recipeComponents.length) {
            Character character = (Character)recipeComponents[i];
            Ingredient ingr = RecipesSF.fromComponent(recipeComponents[i + 1]);
            if (ingr != null) {
                map.put(character, ingr);
            } else {
                SolarFlux.LOG.warn("Unable to parse ingredient!!! Ingredient being parsed: " + recipeComponents[i + 1]);
            }
            i += 2;
        }
        NonNullList aitemstack = NonNullList.func_191197_a((int)(j * k), (Object)Ingredient.field_193370_a);
        for (int l = 0; l < j * k; ++l) {
            char c0 = s.charAt(l);
            if (!map.containsKey(Character.valueOf(c0))) continue;
            aitemstack.set(l, map.get(Character.valueOf(c0)));
        }
        return new ShapedRecipe(RecipesSF.nextId(output.func_77973_b()), "", j, k, aitemstack, output);
    }

    public static Ingredient fromComponent(Object comp) {
        Ingredient ingr = null;
        if (comp instanceof IItemProvider) {
            ingr = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)comp});
        } else if (comp instanceof ItemStack) {
            ingr = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((ItemStack)comp).func_77946_l()});
        } else if (comp instanceof Tag) {
            ingr = Ingredient.func_199805_a((Tag)((Tag)comp));
        } else if (comp instanceof Tag[]) {
            ingr = RecipesSF.fromTags((Tag[])comp);
        } else if (comp instanceof String || comp instanceof ResourceLocation) {
            String st = comp.toString();
            ResourceLocation tag = null;
            ResourceLocation odConv = OreDict.get(st);
            tag = odConv != null ? odConv : new ResourceLocation(st.contains(":") ? st : "forge:" + st);
            ingr = Ingredient.func_199805_a((Tag)ItemTags.func_199903_a().func_199915_b(tag));
        } else if (comp instanceof ItemStack[]) {
            ItemStack[] items = (ItemStack[])((ItemStack[])comp).clone();
            for (int l = 0; l < items.length; ++l) {
                items[l] = items[l].func_77946_l();
            }
            ingr = Ingredient.func_193369_a((ItemStack[])items);
        } else if (comp instanceof Ingredient) {
            ingr = (Ingredient)comp;
        }
        return ingr;
    }

    public static Ingredient fromTags(Tag<Item> ... tags) {
        ArrayList<Ingredient.TagList> list = new ArrayList<Ingredient.TagList>();
        for (Tag<Item> t : tags) {
            list.add(new Ingredient.TagList(t));
        }
        return Ingredient.func_209357_a(list.stream());
    }

    public static Ingredient fromTags(Collection<Tag<Item>> tags) {
        ArrayList<Ingredient.TagList> list = new ArrayList<Ingredient.TagList>();
        for (Tag<Item> t : tags) {
            list.add(new Ingredient.TagList(t));
        }
        return Ingredient.func_209357_a(list.stream());
    }

    private static class SFRRecipeType
    implements IRecipeType<IRecipe<?>> {
        public static final SFRRecipeType INSTANCE = new SFRRecipeType();

        private SFRRecipeType() {
        }

        public boolean equals(Object obj) {
            return obj instanceof SFRRecipeType;
        }
    }
}

