/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.util.BitArray;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;

public class Heightmap {
    private static final Predicate<BlockState> field_222691_a = blockState -> !blockState.func_196958_f();
    private static final Predicate<BlockState> field_222692_b = blockState -> blockState.func_185904_a().func_76230_c();
    private final BitArray field_202275_a = new BitArray(9, 256);
    private final Predicate<BlockState> field_222693_d;
    private final IChunk field_202277_c;

    public Heightmap(IChunk iChunk, Type type) {
        this.field_222693_d = type.func_222684_d();
        this.field_202277_c = iChunk;
    }

    public static void func_222690_a(IChunk iChunk, Set<Type> set) {
        int n = set.size();
        ObjectArrayList \u26032 = new ObjectArrayList(n);
        ObjectListIterator \u26033 = \u26032.iterator();
        int n2 = iChunk.func_76625_h() + 16;
        try (BlockPos.PooledMutable \u26034 = BlockPos.PooledMutable.func_185346_s();){
            for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                block10: for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                    for (Type type : set) {
                        \u26032.add((Object)iChunk.func_217303_b(type));
                    }
                    for (int i = n2 - 1; i >= 0; --i) {
                        \u26034.func_181079_c(\u2603, i, \u2603);
                        BlockState blockState = iChunk.func_180495_p(\u26034);
                        if (blockState.func_177230_c() == Blocks.field_150350_a) continue;
                        while (\u26033.hasNext()) {
                            Heightmap heightmap = (Heightmap)\u26033.next();
                            if (!heightmap.field_222693_d.test(blockState)) continue;
                            heightmap.func_202272_a(\u2603, \u2603, i + 1);
                            \u26033.remove();
                        }
                        if (\u26032.isEmpty()) continue block10;
                        \u26033.back(n);
                    }
                }
            }
        }
    }

    public boolean func_202270_a(int n5, int n2, int n3, BlockState blockState) {
        int n4 = this.func_202273_a(n5, n3);
        if (n2 <= n4 - 2) {
            return false;
        }
        if (this.field_222693_d.test(blockState)) {
            if (n2 >= n4) {
                this.func_202272_a(n5, n3, n2 + 1);
                return true;
            }
        } else if (n4 - 1 == n2) {
            int n5;
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (int i = n2 - 1; i >= 0; --i) {
                mutable.func_181079_c(n5, i, n3);
                if (!this.field_222693_d.test(this.field_202277_c.func_180495_p(mutable))) continue;
                this.func_202272_a(n5, n3, i + 1);
                return true;
            }
            this.func_202272_a(n5, n3, 0);
            return true;
        }
        return false;
    }

    public int func_202273_a(int n, int n2) {
        return this.func_202274_b(Heightmap.func_202267_b(n, n2));
    }

    private int func_202274_b(int n) {
        return this.field_202275_a.func_188142_a(n);
    }

    private void func_202272_a(int n, int n2, int n3) {
        this.field_202275_a.func_188141_a(Heightmap.func_202267_b(n, n2), n3);
    }

    public void func_202268_a(long[] lArray) {
        System.arraycopy(lArray, 0, this.field_202275_a.func_188143_a(), 0, lArray.length);
    }

    public long[] func_202269_a() {
        return this.field_202275_a.func_188143_a();
    }

    private static int func_202267_b(int n, int n2) {
        return n + n2 * 16;
    }

    static /* synthetic */ Predicate func_222687_b() {
        return field_222691_a;
    }

    static /* synthetic */ Predicate func_222686_c() {
        return field_222692_b;
    }

    public static enum Type {
        WORLD_SURFACE_WG("WORLD_SURFACE_WG", Usage.WORLDGEN, Heightmap.func_222687_b()),
        WORLD_SURFACE("WORLD_SURFACE", Usage.CLIENT, Heightmap.func_222687_b()),
        OCEAN_FLOOR_WG("OCEAN_FLOOR_WG", Usage.WORLDGEN, Heightmap.func_222686_c()),
        OCEAN_FLOOR("OCEAN_FLOOR", Usage.LIVE_WORLD, Heightmap.func_222686_c()),
        MOTION_BLOCKING("MOTION_BLOCKING", Usage.CLIENT, blockState -> blockState.func_185904_a().func_76230_c() || !blockState.func_204520_s().func_206888_e()),
        MOTION_BLOCKING_NO_LEAVES("MOTION_BLOCKING_NO_LEAVES", Usage.LIVE_WORLD, blockState -> (blockState.func_185904_a().func_76230_c() || !blockState.func_204520_s().func_206888_e()) && !(blockState.func_177230_c() instanceof LeavesBlock));

        private final String field_203502_f;
        private final Usage field_207513_i;
        private final Predicate<BlockState> field_222685_i;
        private static final Map<String, Type> field_203503_g;

        private Type(String string2, Usage usage, Predicate<BlockState> predicate) {
            this.field_203502_f = string2;
            this.field_207513_i = usage;
            this.field_222685_i = predicate;
        }

        public String func_203500_b() {
            return this.field_203502_f;
        }

        public boolean func_222681_b() {
            return this.field_207513_i == Usage.CLIENT;
        }

        public static Type func_203501_a(String string) {
            return field_203503_g.get(string);
        }

        public Predicate<BlockState> func_222684_d() {
            return this.field_222685_i;
        }

        static {
            field_203503_g = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
                for (Type type : Type.values()) {
                    hashMap.put(type.field_203502_f, type);
                }
            });
        }
    }

    public static enum Usage {
        WORLDGEN,
        LIVE_WORLD,
        CLIENT;

    }
}

