/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class NBTPathArgument
implements ArgumentType<NBTPath> {
    private static final Collection<String> field_201316_a = Arrays.asList("foo", "foo.bar", "foo[0]", "[0]", "[]", "{foo=bar}");
    public static final SimpleCommandExceptionType field_201948_d = new SimpleCommandExceptionType((Message)new TranslationTextComponent("arguments.nbtpath.node.invalid", new Object[0]));
    public static final DynamicCommandExceptionType field_218084_b = new DynamicCommandExceptionType(object -> new TranslationTextComponent("arguments.nbtpath.nothing_found", object));

    public static NBTPathArgument func_197149_a() {
        return new NBTPathArgument();
    }

    public static NBTPath func_197148_a(CommandContext<CommandSource> commandContext, String string) {
        return (NBTPath)commandContext.getArgument(string, NBTPath.class);
    }

    public NBTPath parse(StringReader stringReader2) throws CommandSyntaxException {
        StringReader stringReader2;
        ArrayList arrayList = Lists.newArrayList();
        int \u26032 = stringReader2.getCursor();
        Object2IntOpenHashMap \u26033 = new Object2IntOpenHashMap();
        boolean \u26034 = true;
        while (stringReader2.canRead() && stringReader2.peek() != ' ') {
            INode iNode = NBTPathArgument.func_218079_a(stringReader2, \u26034);
            arrayList.add(iNode);
            \u26033.put((Object)iNode, stringReader2.getCursor() - \u26032);
            \u26034 = false;
            if (!stringReader2.canRead() || (\u2603 = stringReader2.peek()) == ' ' || \u2603 == '[' || \u2603 == '{') continue;
            stringReader2.expect('.');
        }
        return new NBTPath(stringReader2.getString().substring(\u26032, stringReader2.getCursor()), arrayList.toArray(new INode[0]), (Object2IntMap<INode>)\u26033);
    }

    private static INode func_218079_a(StringReader stringReader2, boolean bl) throws CommandSyntaxException {
        switch (stringReader2.peek()) {
            case '{': {
                if (!bl) {
                    throw field_201948_d.createWithContext((ImmutableStringReader)stringReader2);
                }
                CompoundNBT compoundNBT = new JsonToNBT(stringReader2).func_193593_f();
                return new CompoundNode(compoundNBT);
            }
            case '[': {
                StringReader stringReader2;
                stringReader2.skip();
                char \u26032 = stringReader2.peek();
                if (\u26032 == '{') {
                    CompoundNBT compoundNBT = new JsonToNBT(stringReader2).func_193593_f();
                    stringReader2.expect(']');
                    return new ListNode(compoundNBT);
                }
                if (\u26032 == ']') {
                    stringReader2.skip();
                    return EmptyListNode.field_218067_a;
                }
                int \u26033 = stringReader2.readInt();
                stringReader2.expect(']');
                return new CollectionNode(\u26033);
            }
            case '\"': {
                String \u26034 = stringReader2.readString();
                return NBTPathArgument.func_218083_a(stringReader2, \u26034);
            }
        }
        String string = NBTPathArgument.func_197151_a(stringReader2);
        return NBTPathArgument.func_218083_a(stringReader2, string);
    }

    private static INode func_218083_a(StringReader stringReader, String string2) throws CommandSyntaxException {
        String string2;
        if (stringReader.canRead() && stringReader.peek() == '{') {
            CompoundNBT compoundNBT = new JsonToNBT(stringReader).func_193593_f();
            return new JsonNode(string2, compoundNBT);
        }
        return new StringNode(string2);
    }

    private static String func_197151_a(StringReader stringReader) throws CommandSyntaxException {
        int n = stringReader.getCursor();
        while (stringReader.canRead() && NBTPathArgument.func_197146_a(stringReader.peek())) {
            stringReader.skip();
        }
        if (stringReader.getCursor() == n) {
            throw field_201948_d.createWithContext((ImmutableStringReader)stringReader);
        }
        return stringReader.getString().substring(n, stringReader.getCursor());
    }

    public Collection<String> getExamples() {
        return field_201316_a;
    }

    private static boolean func_197146_a(char c) {
        return c != ' ' && c != '\"' && c != '[' && c != ']' && c != '.' && c != '{' && c != '}';
    }

    private static Predicate<INBT> func_218080_b(CompoundNBT compoundNBT) {
        return iNBT -> NBTUtil.func_181123_a(compoundNBT, iNBT, true);
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    static class CompoundNode
    implements INode {
        private final Predicate<INBT> field_218066_a;

        public CompoundNode(CompoundNBT compoundNBT) {
            this.field_218066_a = NBTPathArgument.func_218080_b(compoundNBT);
        }

        @Override
        public void func_218050_a(INBT iNBT, List<INBT> list) {
            if (iNBT instanceof CompoundNBT && this.field_218066_a.test(iNBT)) {
                list.add(iNBT);
            }
        }

        @Override
        public void func_218054_a(INBT iNBT, Supplier<INBT> supplier, List<INBT> list) {
            this.func_218050_a(iNBT, list);
        }

        @Override
        public INBT func_197134_a() {
            return new CompoundNBT();
        }

        @Override
        public int func_218051_a(INBT iNBT, Supplier<INBT> supplier) {
            return 0;
        }

        @Override
        public int func_218053_a(INBT iNBT) {
            return 0;
        }
    }

    static class JsonNode
    implements INode {
        private final String field_218063_a;
        private final CompoundNBT field_218064_b;
        private final Predicate<INBT> field_218065_c;

        public JsonNode(String string, CompoundNBT compoundNBT) {
            this.field_218063_a = string;
            this.field_218064_b = compoundNBT;
            this.field_218065_c = NBTPathArgument.func_218080_b(compoundNBT);
        }

        @Override
        public void func_218050_a(INBT iNBT, List<INBT> list) {
            if (iNBT instanceof CompoundNBT && this.field_218065_c.test(\u2603 = ((CompoundNBT)iNBT).func_74781_a(this.field_218063_a))) {
                list.add(\u2603);
            }
        }

        @Override
        public void func_218054_a(INBT iNBT, Supplier<INBT> supplier, List<INBT> list) {
            if (iNBT instanceof CompoundNBT) {
                CompoundNBT compoundNBT = (CompoundNBT)iNBT;
                INBT \u26032 = compoundNBT.func_74781_a(this.field_218063_a);
                if (\u26032 == null) {
                    \u26032 = this.field_218064_b.func_74737_b();
                    compoundNBT.func_218657_a(this.field_218063_a, \u26032);
                    list.add(\u26032);
                } else if (this.field_218065_c.test(\u26032)) {
                    list.add(\u26032);
                }
            }
        }

        @Override
        public INBT func_197134_a() {
            return new CompoundNBT();
        }

        @Override
        public int func_218051_a(INBT iNBT, Supplier<INBT> supplier) {
            if (iNBT instanceof CompoundNBT && this.field_218065_c.test(\u2603 = (\u2603 = (CompoundNBT)iNBT).func_74781_a(this.field_218063_a)) && !(\u2603 = supplier.get()).equals(\u2603)) {
                \u2603.func_218657_a(this.field_218063_a, \u2603);
                return 1;
            }
            return 0;
        }

        @Override
        public int func_218053_a(INBT iNBT) {
            if (iNBT instanceof CompoundNBT && this.field_218065_c.test(\u2603 = (\u2603 = (CompoundNBT)iNBT).func_74781_a(this.field_218063_a))) {
                \u2603.func_82580_o(this.field_218063_a);
                return 1;
            }
            return 0;
        }
    }

    static class EmptyListNode
    implements INode {
        public static final EmptyListNode field_218067_a = new EmptyListNode();

        private EmptyListNode() {
        }

        @Override
        public void func_218050_a(INBT iNBT, List<INBT> list) {
            if (iNBT instanceof CollectionNBT) {
                list.addAll((CollectionNBT)iNBT);
            }
        }

        @Override
        public void func_218054_a(INBT iNBT, Supplier<INBT> supplier, List<INBT> list2) {
            if (iNBT instanceof CollectionNBT) {
                CollectionNBT collectionNBT = (CollectionNBT)iNBT;
                if (collectionNBT.isEmpty()) {
                    INBT iNBT2 = supplier.get();
                    if (collectionNBT.func_218660_b(0, iNBT2)) {
                        list2.add(iNBT2);
                    }
                } else {
                    List<INBT> list2;
                    list2.addAll(collectionNBT);
                }
            }
        }

        @Override
        public INBT func_197134_a() {
            return new ListNBT();
        }

        @Override
        public int func_218051_a(INBT iNBT, Supplier<INBT> supplier) {
            if (iNBT instanceof CollectionNBT) {
                CollectionNBT collectionNBT = (CollectionNBT)iNBT;
                int \u26032 = collectionNBT.size();
                if (\u26032 == 0) {
                    collectionNBT.func_218660_b(0, supplier.get());
                    return 1;
                }
                INBT \u26033 = supplier.get();
                int \u26034 = \u26032 - (int)collectionNBT.stream().filter(\u26033::equals).count();
                if (\u26034 == 0) {
                    return 0;
                }
                collectionNBT.clear();
                if (!collectionNBT.func_218660_b(0, \u26033)) {
                    return 0;
                }
                for (int i = 1; i < \u26032; ++i) {
                    collectionNBT.func_218660_b(i, supplier.get());
                }
                return \u26034;
            }
            return 0;
        }

        @Override
        public int func_218053_a(INBT iNBT) {
            if (iNBT instanceof CollectionNBT && (\u2603 = (\u2603 = (CollectionNBT)iNBT).size()) > 0) {
                \u2603.clear();
                return \u2603;
            }
            return 0;
        }
    }

    static class ListNode
    implements INode {
        private final CompoundNBT field_218061_a;
        private final Predicate<INBT> field_218062_b;

        public ListNode(CompoundNBT compoundNBT) {
            this.field_218061_a = compoundNBT;
            this.field_218062_b = NBTPathArgument.func_218080_b(compoundNBT);
        }

        @Override
        public void func_218050_a(INBT iNBT, List<INBT> list) {
            if (iNBT instanceof ListNBT) {
                ListNBT listNBT = (ListNBT)iNBT;
                listNBT.stream().filter(this.field_218062_b).forEach(list::add);
            }
        }

        @Override
        public void func_218054_a(INBT iNBT2, Supplier<INBT> supplier, List<INBT> list) {
            MutableBoolean mutableBoolean = new MutableBoolean();
            if (iNBT2 instanceof ListNBT) {
                ListNBT listNBT = (ListNBT)iNBT2;
                listNBT.stream().filter(this.field_218062_b).forEach(iNBT -> {
                    list.add((INBT)iNBT);
                    mutableBoolean.setTrue();
                });
                if (mutableBoolean.isFalse()) {
                    CompoundNBT compoundNBT = this.field_218061_a.func_74737_b();
                    listNBT.add(compoundNBT);
                    list.add(compoundNBT);
                }
            }
        }

        @Override
        public INBT func_197134_a() {
            return new ListNBT();
        }

        @Override
        public int func_218051_a(INBT iNBT, Supplier<INBT> supplier) {
            int n = 0;
            if (iNBT instanceof ListNBT) {
                ListNBT listNBT = (ListNBT)iNBT;
                int \u26032 = listNBT.size();
                if (\u26032 == 0) {
                    listNBT.add(supplier.get());
                    ++n;
                } else {
                    for (int i = 0; i < \u26032; ++i) {
                        INBT iNBT2 = listNBT.get(i);
                        if (!this.field_218062_b.test(iNBT2) || (\u2603 = supplier.get()).equals(iNBT2) || !listNBT.func_218659_a(i, \u2603)) continue;
                        ++n;
                    }
                }
            }
            return n;
        }

        @Override
        public int func_218053_a(INBT iNBT) {
            int n = 0;
            if (iNBT instanceof ListNBT) {
                ListNBT listNBT = (ListNBT)iNBT;
                for (int i = listNBT.size() - 1; i >= 0; --i) {
                    if (!this.field_218062_b.test(listNBT.get(i))) continue;
                    listNBT.remove(i);
                    ++n;
                }
            }
            return n;
        }
    }

    static class CollectionNode
    implements INode {
        private final int field_218059_a;

        public CollectionNode(int n) {
            this.field_218059_a = n;
        }

        @Override
        public void func_218050_a(INBT iNBT, List<INBT> list) {
            if (iNBT instanceof CollectionNBT) {
                CollectionNBT collectionNBT = (CollectionNBT)iNBT;
                int \u26032 = collectionNBT.size();
                int n = \u2603 = this.field_218059_a < 0 ? \u26032 + this.field_218059_a : this.field_218059_a;
                if (0 <= \u2603 && \u2603 < \u26032) {
                    list.add((INBT)collectionNBT.get(\u2603));
                }
            }
        }

        @Override
        public void func_218054_a(INBT iNBT, Supplier<INBT> supplier, List<INBT> list) {
            this.func_218050_a(iNBT, list);
        }

        @Override
        public INBT func_197134_a() {
            return new ListNBT();
        }

        @Override
        public int func_218051_a(INBT iNBT, Supplier<INBT> supplier) {
            if (iNBT instanceof CollectionNBT) {
                CollectionNBT collectionNBT = (CollectionNBT)iNBT;
                int \u26032 = collectionNBT.size();
                int n = \u2603 = this.field_218059_a < 0 ? \u26032 + this.field_218059_a : this.field_218059_a;
                if (0 <= \u2603 && \u2603 < \u26032) {
                    INBT iNBT2 = (INBT)collectionNBT.get(\u2603);
                    \u2603 = supplier.get();
                    if (!\u2603.equals(iNBT2) && collectionNBT.func_218659_a(\u2603, \u2603)) {
                        return 1;
                    }
                }
            }
            return 0;
        }

        @Override
        public int func_218053_a(INBT iNBT) {
            if (iNBT instanceof CollectionNBT) {
                CollectionNBT collectionNBT = (CollectionNBT)iNBT;
                int \u26032 = collectionNBT.size();
                int n = \u2603 = this.field_218059_a < 0 ? \u26032 + this.field_218059_a : this.field_218059_a;
                if (0 <= \u2603 && \u2603 < \u26032) {
                    collectionNBT.remove(\u2603);
                    return 1;
                }
            }
            return 0;
        }
    }

    static class StringNode
    implements INode {
        private final String field_218058_a;

        public StringNode(String string) {
            this.field_218058_a = string;
        }

        @Override
        public void func_218050_a(INBT iNBT, List<INBT> list) {
            if (iNBT instanceof CompoundNBT && (\u2603 = ((CompoundNBT)iNBT).func_74781_a(this.field_218058_a)) != null) {
                list.add(\u2603);
            }
        }

        @Override
        public void func_218054_a(INBT iNBT, Supplier<INBT> supplier2, List<INBT> list) {
            if (iNBT instanceof CompoundNBT) {
                INBT \u26032;
                CompoundNBT compoundNBT = (CompoundNBT)iNBT;
                if (compoundNBT.func_74764_b(this.field_218058_a)) {
                    \u26032 = compoundNBT.func_74781_a(this.field_218058_a);
                } else {
                    Supplier<INBT> supplier2;
                    \u26032 = supplier2.get();
                    compoundNBT.func_218657_a(this.field_218058_a, \u26032);
                }
                list.add(\u26032);
            }
        }

        @Override
        public INBT func_197134_a() {
            return new CompoundNBT();
        }

        @Override
        public int func_218051_a(INBT iNBT, Supplier<INBT> supplier) {
            if (iNBT instanceof CompoundNBT) {
                CompoundNBT compoundNBT = (CompoundNBT)iNBT;
                INBT \u26032 = supplier.get();
                if (!\u26032.equals(\u2603 = compoundNBT.func_218657_a(this.field_218058_a, \u26032))) {
                    return 1;
                }
            }
            return 0;
        }

        @Override
        public int func_218053_a(INBT iNBT) {
            if (iNBT instanceof CompoundNBT && (\u2603 = (CompoundNBT)iNBT).func_74764_b(this.field_218058_a)) {
                \u2603.func_82580_o(this.field_218058_a);
                return 1;
            }
            return 0;
        }
    }

    static interface INode {
        public void func_218050_a(INBT var1, List<INBT> var2);

        public void func_218054_a(INBT var1, Supplier<INBT> var2, List<INBT> var3);

        public INBT func_197134_a();

        public int func_218051_a(INBT var1, Supplier<INBT> var2);

        public int func_218053_a(INBT var1);

        default public List<INBT> func_218056_a(List<INBT> list) {
            return this.func_218057_a(list, this::func_218050_a);
        }

        default public List<INBT> func_218052_a(List<INBT> list2, Supplier<INBT> supplier) {
            return this.func_218057_a(list2, (iNBT, list) -> this.func_218054_a((INBT)iNBT, supplier, (List<INBT>)list));
        }

        default public List<INBT> func_218057_a(List<INBT> list, BiConsumer<INBT, List<INBT>> biConsumer) {
            ArrayList arrayList = Lists.newArrayList();
            for (INBT iNBT : list) {
                biConsumer.accept(iNBT, arrayList);
            }
            return arrayList;
        }
    }

    public static class NBTPath {
        private final String field_197144_a;
        private final Object2IntMap<INode> field_218078_b;
        private final INode[] field_197145_b;

        public NBTPath(String string, INode[] iNodeArray, Object2IntMap<INode> object2IntMap) {
            this.field_197144_a = string;
            this.field_197145_b = iNodeArray;
            this.field_218078_b = object2IntMap;
        }

        public List<INBT> func_218071_a(INBT iNBT) throws CommandSyntaxException {
            List<INBT> list = Collections.singletonList(iNBT);
            for (INode iNode : this.field_197145_b) {
                if (!(list = iNode.func_218056_a(list)).isEmpty()) continue;
                throw this.func_218070_a(iNode);
            }
            return list;
        }

        public int func_218069_b(INBT iNBT) {
            List<INBT> list = Collections.singletonList(iNBT);
            for (INode iNode : this.field_197145_b) {
                if (!(list = iNode.func_218056_a(list)).isEmpty()) continue;
                return 0;
            }
            return list.size();
        }

        private List<INBT> func_218072_d(INBT iNBT) throws CommandSyntaxException {
            List<INBT> list = Collections.singletonList(iNBT);
            for (int i = 0; i < this.field_197145_b.length - 1; ++i) {
                INode iNode = this.field_197145_b[i];
                int \u26032 = i + 1;
                if (!(list = iNode.func_218052_a(list, this.field_197145_b[\u26032]::func_197134_a)).isEmpty()) continue;
                throw this.func_218070_a(iNode);
            }
            return list;
        }

        public List<INBT> func_218073_a(INBT iNBT, Supplier<INBT> supplier) throws CommandSyntaxException {
            List<INBT> list = this.func_218072_d(iNBT);
            INode \u26032 = this.field_197145_b[this.field_197145_b.length - 1];
            return \u26032.func_218052_a(list, supplier);
        }

        private static int func_218075_a(List<INBT> list, Function<INBT, Integer> function) {
            return list.stream().map(function).reduce(0, (n, n2) -> n + n2);
        }

        public int func_218076_b(INBT iNBT2, Supplier<INBT> supplier) throws CommandSyntaxException {
            List<INBT> list = this.func_218072_d(iNBT2);
            INode \u26032 = this.field_197145_b[this.field_197145_b.length - 1];
            return NBTPath.func_218075_a(list, iNBT -> \u26032.func_218051_a((INBT)iNBT, supplier));
        }

        public int func_218068_c(INBT iNBT) {
            List<INBT> list = Collections.singletonList(iNBT);
            for (int i = 0; i < this.field_197145_b.length - 1; ++i) {
                list = this.field_197145_b[i].func_218056_a(list);
            }
            INode iNode = this.field_197145_b[this.field_197145_b.length - 1];
            return NBTPath.func_218075_a(list, iNode::func_218053_a);
        }

        private CommandSyntaxException func_218070_a(INode iNode) {
            int n = this.field_218078_b.getInt((Object)iNode);
            return field_218084_b.create((Object)this.field_197144_a.substring(0, n));
        }

        public String toString() {
            return this.field_197144_a;
        }
    }
}

