/*
 * Decompiled with CFR 0.152.
 */
package uppers.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import uppers.tiles.IUpper;
import uppers.tiles.UpperTileEntity;

public class UpperBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty ENABLED = BlockStateProperties.field_208180_g;
    private static final VoxelShape INPUT_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.func_208617_a((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape INPUT_MIDDLE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)MIDDLE_SHAPE, (VoxelShape)INPUT_SHAPE);
    private static final VoxelShape field_196326_A = VoxelShapes.func_197878_a((VoxelShape)INPUT_MIDDLE_SHAPE, (VoxelShape)IUpper.INSIDE_BOWL_SHAPE, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape DOWN_SHAPE = VoxelShapes.func_197872_a((VoxelShape)field_196326_A, (VoxelShape)Block.func_208617_a((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)field_196326_A, (VoxelShape)Block.func_208617_a((double)12.0, (double)8.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0));
    private static final VoxelShape NORTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)field_196326_A, (VoxelShape)Block.func_208617_a((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)12.0, (double)4.0));
    private static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)field_196326_A, (VoxelShape)Block.func_208617_a((double)6.0, (double)8.0, (double)12.0, (double)10.0, (double)12.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)field_196326_A, (VoxelShape)Block.func_208617_a((double)0.0, (double)8.0, (double)6.0, (double)4.0, (double)12.0, (double)10.0));
    private static final VoxelShape DOWN_RAYTRACE_SHAPE = IUpper.INSIDE_BOWL_SHAPE;
    private static final VoxelShape EAST_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IUpper.INSIDE_BOWL_SHAPE, (VoxelShape)Block.func_208617_a((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0));
    private static final VoxelShape NORTH_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IUpper.INSIDE_BOWL_SHAPE, (VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0));
    private static final VoxelShape SOUTH_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IUpper.INSIDE_BOWL_SHAPE, (VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IUpper.INSIDE_BOWL_SHAPE, (VoxelShape)Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0));

    public UpperBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.UP)).func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case UP: {
                return DOWN_SHAPE;
            }
            case DOWN: {
                return DOWN_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return field_196326_A;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case UP: {
                return DOWN_RAYTRACE_SHAPE;
            }
            case DOWN: {
                return DOWN_RAYTRACE_SHAPE;
            }
            case NORTH: {
                return NORTH_RAYTRACE_SHAPE;
            }
            case SOUTH: {
                return SOUTH_RAYTRACE_SHAPE;
            }
            case WEST: {
                return WEST_RAYTRACE_SHAPE;
            }
            case EAST: {
                return EAST_RAYTRACE_SHAPE;
            }
        }
        return IUpper.INSIDE_BOWL_SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l().func_176734_d();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)(direction.func_176740_k() == Direction.Axis.Y ? Direction.UP : direction))).func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new UpperTileEntity();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof UpperTileEntity) {
            ((UpperTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c()) {
            this.updateState(worldIn, pos, state);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof UpperTileEntity) {
            player.func_213829_a((INamedContainerProvider)((UpperTileEntity)tileentity));
            player.func_195066_a(Stats.field_188084_R);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.updateState(world, pos, state);
    }

    private void updateState(World world, BlockPos pos, BlockState state) {
        boolean flag;
        boolean bl = flag = !world.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((IProperty)ENABLED)) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(flag)), 4);
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof UpperTileEntity) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((UpperTileEntity)tileentity));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, ENABLED});
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof UpperTileEntity) {
            ((UpperTileEntity)tileentity).onEntityCollision(entity);
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return false;
    }
}

