/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.control;

import cofh.core.network.packet.server.SecurityControlPacket;
import cofh.lib.util.Utils;
import cofh.lib.util.control.ISecurable;
import cofh.lib.util.control.ISecurableTile;
import cofh.lib.util.helpers.SecurityHelper;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class SecurityControlModule
implements ISecurable {
    protected ISecurableTile tile;
    protected boolean enabled;
    protected GameProfile owner = SecurityHelper.DEFAULT_GAME_PROFILE;
    protected ISecurable.AccessMode access = ISecurable.AccessMode.PUBLIC;

    public SecurityControlModule(ISecurableTile tile) {
        this(tile, true);
    }

    public SecurityControlModule(ISecurableTile tile, boolean enabled) {
        this.tile = tile;
        this.enabled = enabled;
    }

    public SecurityControlModule setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void readFromBuffer(PacketBuffer buffer) {
        this.access = ISecurable.AccessMode.VALUES[buffer.readByte()];
        this.owner = SecurityHelper.DEFAULT_GAME_PROFILE;
        this.setOwner(new GameProfile(buffer.func_179253_g(), buffer.func_150789_c(1024)));
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.writeByte(this.access.ordinal());
        buffer.func_179252_a(this.owner.getId());
        buffer.func_180714_a(this.owner.getName());
    }

    public SecurityControlModule read(CompoundNBT nbt) {
        if (nbt.func_74764_b("OwnerUUID")) {
            String uuid = nbt.func_74779_i("OwnerUUID");
            String name = nbt.func_74779_i("OwnerName");
            this.owner = new GameProfile(UUID.fromString(uuid), name);
        } else {
            this.owner = SecurityHelper.DEFAULT_GAME_PROFILE;
        }
        this.access = this.isSecurable() ? ISecurable.AccessMode.VALUES[nbt.func_74771_c("Access")] : ISecurable.AccessMode.PUBLIC;
        return this;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        if (this.enabled) {
            nbt.func_74778_a("OwnerUUID", this.owner.getId().toString());
            nbt.func_74778_a("OwnerName", this.owner.getName());
            nbt.func_74774_a("Access", (byte)this.access.ordinal());
        }
        return nbt;
    }

    @Override
    public boolean isSecurable() {
        return this.enabled;
    }

    @Override
    public ISecurable.AccessMode getAccess() {
        return this.access;
    }

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setAccess(ISecurable.AccessMode access) {
        ISecurable.AccessMode curAccess = this.access;
        this.access = access;
        if (Utils.isClientWorld(this.tile.world())) {
            SecurityControlPacket.sendToServer(this.tile);
            this.access = curAccess;
        } else {
            this.tile.onControlUpdate();
        }
    }

    @Override
    public boolean setOwner(GameProfile profile) {
        if (!this.isSecurable()) {
            return false;
        }
        if (SecurityHelper.isDefaultProfile(this.owner) && !SecurityHelper.isDefaultProfile(profile)) {
            this.owner = profile;
            if (Utils.isServerWorld(this.tile.world())) {
                this.tile.onControlUpdate();
            }
            return true;
        }
        return false;
    }
}

