/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.control;

import net.minecraft.state.EnumProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;

public interface IReconfigurable {
    public static final EnumProperty<SideConfig> RECONFIG_NORTH = EnumProperty.func_177709_a((String)"config_north", SideConfig.class);
    public static final EnumProperty<SideConfig> RECONFIG_EAST = EnumProperty.func_177709_a((String)"config_east", SideConfig.class);
    public static final EnumProperty<SideConfig> RECONFIG_SOUTH = EnumProperty.func_177709_a((String)"config_south", SideConfig.class);
    public static final EnumProperty<SideConfig> RECONFIG_WEST = EnumProperty.func_177709_a((String)"config_west", SideConfig.class);
    public static final EnumProperty<SideConfig> RECONFIG_DOWN = EnumProperty.func_177709_a((String)"config_down", SideConfig.class);
    public static final EnumProperty<SideConfig> RECONFIG_UP = EnumProperty.func_177709_a((String)"config_up", SideConfig.class);

    public SideConfig getSideConfig(Direction var1);

    public boolean prevSideConfig(Direction var1);

    public boolean nextSideConfig(Direction var1);

    public boolean setSideConfig(Direction var1, SideConfig var2);

    public boolean clearAllSides();

    public boolean hasInputSide();

    public boolean hasOutputSide();

    default public boolean isReconfigurable() {
        return true;
    }

    public static enum SideConfig implements IStringSerializable
    {
        SIDE_NONE("none", false, false),
        SIDE_INPUT("input", true, false),
        SIDE_OUTPUT("output", false, true),
        SIDE_BOTH("both", true, true),
        SIDE_ACCESSIBLE("accessible", false, false);

        public static final SideConfig[] VALUES;
        private final String name;
        private final boolean input;
        private final boolean output;

        private SideConfig(String name, boolean input, boolean output) {
            this.name = name;
            this.input = input;
            this.output = output;
        }

        public boolean isInput() {
            return this.input;
        }

        public boolean isOutput() {
            return this.output;
        }

        SideConfig prev() {
            switch (this) {
                case SIDE_INPUT: {
                    return SIDE_NONE;
                }
                case SIDE_OUTPUT: {
                    return SIDE_INPUT;
                }
                case SIDE_BOTH: {
                    return SIDE_OUTPUT;
                }
                case SIDE_ACCESSIBLE: {
                    return SIDE_BOTH;
                }
            }
            return SIDE_ACCESSIBLE;
        }

        SideConfig next() {
            switch (this) {
                case SIDE_NONE: {
                    return SIDE_INPUT;
                }
                case SIDE_INPUT: {
                    return SIDE_OUTPUT;
                }
                case SIDE_OUTPUT: {
                    return SIDE_BOTH;
                }
                case SIDE_BOTH: {
                    return SIDE_ACCESSIBLE;
                }
            }
            return SIDE_NONE;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            VALUES = SideConfig.values();
        }
    }
}

