/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.item;

import cofh.lib.capability.templates.AOEMiningItem;
import cofh.lib.util.constants.ToolTypes;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class SickleItem
extends ToolItem {
    public static final Set<Block> EFFECTIVE_BLOCKS = ImmutableSet.of();
    public static final Set<Material> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.field_151584_j, (Object)Material.field_151585_k, (Object)Material.field_151582_l, (Object)Material.field_151569_G);
    private static float DEFAULT_ATTACK_DAMAGE = 2.5f;
    private static float DEFAULT_ATTACK_SPEED = -2.6f;
    private static int DEFAULT_BASE_RADIUS = 2;
    private static int DEFAULT_BASE_HEIGHT = 0;
    private int radius;
    private int height;

    public SickleItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, int radius, int height, Item.Properties builder) {
        super(attackDamageIn, attackSpeedIn, tier, EFFECTIVE_BLOCKS, builder.addToolType(ToolTypes.SICKLE, tier.func_200925_d()));
        this.radius = radius;
        this.height = height;
    }

    public SickleItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        this(tier, attackDamageIn, attackSpeedIn, DEFAULT_BASE_RADIUS, DEFAULT_BASE_HEIGHT, builder.addToolType(ToolTypes.SICKLE, tier.func_200925_d()));
    }

    public SickleItem(IItemTier tier, float attackDamageIn, Item.Properties builder) {
        this(tier, attackDamageIn, DEFAULT_ATTACK_SPEED, DEFAULT_BASE_RADIUS, DEFAULT_BASE_HEIGHT, builder.addToolType(ToolTypes.SICKLE, tier.func_200925_d()));
    }

    public SickleItem(IItemTier tier, Item.Properties builder) {
        this(tier, DEFAULT_ATTACK_DAMAGE, DEFAULT_ATTACK_SPEED, DEFAULT_BASE_RADIUS, DEFAULT_BASE_HEIGHT, builder.addToolType(ToolTypes.SICKLE, tier.func_200925_d()));
    }

    public boolean func_150897_b(BlockState state) {
        if (state.getHarvestTool() == ToolTypes.SICKLE) {
            return this.func_200891_e().func_200925_d() >= state.getHarvestLevel();
        }
        return EFFECTIVE_MATERIALS.contains(state.func_185904_a());
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_196553_aF) {
            return 15.0f;
        }
        return EFFECTIVE_MATERIALS.contains(state.func_185904_a()) ? this.field_77864_a : 1.0f;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new AOEMiningItem(this.radius, this.height, AOEMiningItem.Type.SICKLE);
    }
}

