/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.item;

import cofh.lib.util.helpers.SecurityHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class BlockItemCoFH
extends BlockItem {
    protected boolean showEnchantEffect = true;
    protected boolean showInItemGroup = true;
    protected boolean creative;
    protected int enchantability;
    protected Supplier<ItemGroup> displayGroup;

    public BlockItemCoFH(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public BlockItemCoFH setCreative(boolean creative) {
        this.creative = creative;
        return this;
    }

    public BlockItemCoFH setEnchantability(int enchantability) {
        this.enchantability = enchantability;
        return this;
    }

    public BlockItemCoFH setDisplayGroup(Supplier<ItemGroup> displayGroup) {
        this.displayGroup = displayGroup;
        return this;
    }

    public final boolean isCreative() {
        return this.creative;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.showInItemGroup) {
            return;
        }
        if (this.func_179223_d() != null) {
            super.func_150895_a(group, items);
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return SecurityHelper.hasSecurity(stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.enchantability > 0;
    }

    public int func_77619_b() {
        return this.enchantability;
    }

    @Nullable
    public Entity createEntity(World world, Entity location, ItemStack stack) {
        if (SecurityHelper.hasSecurity(stack)) {
            location.func_184224_h(true);
            ((ItemEntity)location).lifespan = Integer.MAX_VALUE;
        }
        return null;
    }

    protected boolean func_194125_a(ItemGroup group) {
        return this.getCreativeTabs().stream().anyMatch(tab -> tab == group);
    }

    public Collection<ItemGroup> getCreativeTabs() {
        return this.displayGroup != null && this.displayGroup.get() != null ? Collections.singletonList(this.displayGroup.get()) : super.getCreativeTabs();
    }
}

