/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.capability.templates;

import cofh.lib.capability.CapabilityEnchantable;
import cofh.lib.capability.IEnchantableItem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class EnchantableItem
implements IEnchantableItem,
ICapabilityProvider {
    private final LazyOptional<IEnchantableItem> holder = LazyOptional.of(() -> this);
    final Set<Enchantment> validEnchantments = new HashSet<Enchantment>();

    public EnchantableItem(List<Enchantment> enchantments) {
        this.validEnchantments.addAll(enchantments);
    }

    public EnchantableItem addEnchantment(Enchantment ench) {
        this.validEnchantments.add(ench);
        return this;
    }

    public EnchantableItem removeEnchantment(Enchantment ench) {
        this.validEnchantments.remove(ench);
        return this;
    }

    @Override
    public boolean supportsEnchantment(ItemStack stack, Enchantment ench) {
        return this.validEnchantments.contains(ench);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityEnchantable.ENCHANTABLE_ITEM_CAPABILITY.orEmpty(cap, this.holder);
    }
}

