/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.helpers.ItemHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class MultiModeItemPacket
extends PacketBase
implements IPacketServer {
    protected boolean decr;

    public MultiModeItemPacket() {
        super(32, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayerEntity player) {
        if (!ItemHelper.isPlayerHoldingMultiModeItem((PlayerEntity)player)) {
            return;
        }
        if (this.decr && ItemHelper.decrHeldMultiModeItemState((PlayerEntity)player) || ItemHelper.incrHeldMultiModeItemState((PlayerEntity)player)) {
            ItemStack heldItem = ItemHelper.getHeldMultiModeStack((PlayerEntity)player);
            ((IMultiModeItem)heldItem.func_77973_b()).onModeChange((PlayerEntity)player, heldItem);
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeBoolean(this.decr);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.decr = buf.readBoolean();
    }

    public static void incrMode() {
        MultiModeItemPacket.sendToServer(false);
    }

    public static void decrMode() {
        MultiModeItemPacket.sendToServer(true);
    }

    private static void sendToServer(boolean decr) {
        MultiModeItemPacket packet = new MultiModeItemPacket();
        packet.decr = decr;
        packet.sendToServer();
    }
}

