/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.network.NetworkHooks;

public class MahouTsukaiTeleporter {
    public static void teleport(Entity entity, double x, double y, double z, DimensionType dim) {
        MahouTsukaiTeleporter.teleport(entity, dim, new BlockPos(x, y, z));
    }

    public static Entity teleport(Entity entity, DimensionType destination, BlockPos pos) {
        if (entity.field_71093_bK == null) {
            entity.field_71093_bK = DimensionType.field_223227_a_;
        }
        if (entity.field_71093_bK.equals(destination)) {
            entity.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            return entity;
        }
        if (!ForgeHooks.onTravelToDimension((Entity)entity, (DimensionType)destination)) {
            return null;
        }
        DimensionType source = entity.field_71093_bK;
        if (entity.field_70170_p.func_73046_m() == null) {
            return entity;
        }
        ServerWorld originalWorld = entity.field_70170_p.func_73046_m().func_71218_a(source);
        entity.field_71093_bK = destination;
        ServerWorld destinationWorld = entity.field_70170_p.func_73046_m().func_71218_a(destination);
        WorldInfo worldinfo = entity.field_70170_p.func_72912_H();
        boolean isplayer = entity instanceof ServerPlayerEntity;
        ServerPlayerEntity player = null;
        PlayerList playerlist = null;
        if (isplayer) {
            player = (ServerPlayerEntity)entity;
            NetworkHooks.sendDimensionDataPacket((NetworkManager)player.field_71135_a.field_147371_a, (ServerPlayerEntity)player);
            player.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(destination, WorldInfo.func_227498_c_((long)worldinfo.func_76063_b()), worldinfo.func_76067_t(), player.field_71134_c.func_73081_b()));
            player.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
            playerlist = player.field_71133_b.func_184103_al();
            playerlist.func_187243_f(player);
        }
        originalWorld.removeEntity(entity, true);
        entity.revive();
        Vec3d vec = entity.func_213303_ch();
        double d0 = vec.field_72450_a;
        double d1 = vec.field_72448_b;
        double d2 = vec.field_72449_c;
        float f = entity.field_70125_A;
        float f1 = entity.field_70177_z;
        double d3 = 8.0;
        originalWorld.func_217381_Z().func_76320_a("moving");
        double moveFactor = originalWorld.func_201675_m().getMovementFactor() / destinationWorld.func_201675_m().getMovementFactor();
        entity.func_70012_b(d0 *= moveFactor, d1, d2 *= moveFactor, f1, f);
        originalWorld.func_217381_Z().func_76319_b();
        originalWorld.func_217381_Z().func_76320_a("placing");
        double d7 = Math.min(-2.9999872E7, destinationWorld.func_175723_af().func_177726_b() + 16.0);
        double d4 = Math.min(-2.9999872E7, destinationWorld.func_175723_af().func_177736_c() + 16.0);
        double d5 = Math.min(2.9999872E7, destinationWorld.func_175723_af().func_177728_d() - 16.0);
        double d6 = Math.min(2.9999872E7, destinationWorld.func_175723_af().func_177733_e() - 16.0);
        d0 = MathHelper.func_151237_a((double)d0, (double)d7, (double)d5);
        d2 = MathHelper.func_151237_a((double)d2, (double)d4, (double)d6);
        entity.func_70012_b(d0, d1, d2, f1, f);
        originalWorld.func_217381_Z().func_76319_b();
        entity.func_70029_a((World)destinationWorld);
        if (isplayer && player != null) {
            destinationWorld.func_217447_b(player);
        }
        vec = entity.func_213303_ch();
        if (isplayer && playerlist != null) {
            player.field_71135_a.func_147364_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, f1, f);
            player.field_71134_c.field_73092_a = destinationWorld;
            player.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
            playerlist.func_72354_b(player, destinationWorld);
            playerlist.func_72385_f(player);
            for (EffectInstance effectinstance : player.func_70651_bq()) {
                player.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(entity.func_145782_y(), effectinstance));
            }
            player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
            player.func_195399_b(player.field_71068_ca);
            player.func_70606_j(player.func_110143_aJ());
            player.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)player, (DimensionType)source, (DimensionType)destination);
        }
        if (!isplayer) {
            Entity e2 = entity.func_200600_R().func_200721_a((World)destinationWorld);
            if (e2 != null) {
                e2.func_180432_n(entity);
                e2.func_174828_a(pos, e2.field_70177_z + f, e2.field_70125_A);
                e2.func_213317_d(new Vec3d(0.0, 0.0, 0.0));
                destinationWorld.func_217460_e(e2);
            }
            return e2;
        }
        return entity;
    }
}

