/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

public class ProximityProjectionKeysModel
implements IModelGeometry<ProximityProjectionKeysModel> {
    public static ResourceLocation redkey = new ResourceLocation("mahoutsukai", "items/red_key_64");
    public static ResourceLocation redkeymodel = new ResourceLocation("mahoutsukai", "item/proximity_projection_key");

    public Collection<? extends IModelGeometryPart> getParts() {
        return null;
    }

    public Optional<? extends IModelGeometryPart> getPart(String name) {
        return Optional.empty();
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        float tx = 8.0f;
        float tz = 8.0f;
        float distance = 2.1f;
        TransformationMatrix transform1 = new TransformationMatrix(new Vector3f(-tx / 16.0f, tz / 16.0f, 0.0f), new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), -90.0f, true), new Vector3f(1.33f, 1.33f, 1.33f), null);
        TransformationMatrix transform2 = new TransformationMatrix(new Vector3f(-tx / 16.0f, tz / 16.0f, 0.0f + distance / 16.0f), new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), -90.0f, true), new Vector3f(1.33f, 1.33f, 1.33f), null);
        TransformationMatrix transform3 = new TransformationMatrix(new Vector3f(-tx / 16.0f, tz / 16.0f, 0.0f - distance / 16.0f), new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), -90.0f, true), new Vector3f(1.33f, 1.33f, 1.33f), null);
        transform1.blockCenterToCorner();
        transform2.blockCenterToCorner();
        transform3.blockCenterToCorner();
        IBakedModel akey1 = Minecraft.func_71410_x().func_209506_al().getModel(redkeymodel);
        IBakedModel akey2 = Minecraft.func_71410_x().func_209506_al().getModel(redkeymodel);
        IBakedModel akey3 = Minecraft.func_71410_x().func_209506_al().getModel(redkeymodel);
        IModelTransform transformsFromModel = owner.getCombinedTransform();
        ImmutableMap transformMap = transformsFromModel != null ? PerspectiveMapWrapper.getTransforms((IModelTransform)new ModelTransformComposition(transformsFromModel, modelTransform)) : PerspectiveMapWrapper.getTransforms((IModelTransform)modelTransform);
        ImmutableList.Builder quadBuilder = ImmutableList.builder();
        if (akey1 != null && akey2 != null && akey3 != null) {
            QuadTransformer qt1 = new QuadTransformer(transform1);
            QuadTransformer qt2 = new QuadTransformer(transform2);
            QuadTransformer qt3 = new QuadTransformer(transform3);
            quadBuilder.addAll((Iterable)qt1.processMany(akey1.getQuads(null, null, new Random(), (IModelData)EmptyModelData.INSTANCE)));
            quadBuilder.addAll((Iterable)qt2.processMany(akey2.getQuads(null, null, new Random(), (IModelData)EmptyModelData.INSTANCE)));
            quadBuilder.addAll((Iterable)qt3.processMany(akey3.getQuads(null, null, new Random(), (IModelData)EmptyModelData.INSTANCE)));
        }
        return new BakedProximityProjectionKeysModel(bakery, owner, this, (ImmutableList<BakedQuad>)quadBuilder.build(), spriteGetter.apply(owner.resolveTexture(redkey.toString())), (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap(), modelTransform.func_225615_b_().isIdentity(), modelTransform, owner.isSideLit());
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        texs.add(owner.resolveTexture(redkey.toString()));
        return texs;
    }

    private static final class BakedProximityProjectionKeysModel
    extends BakedItemModel {
        private final IModelConfiguration owner;
        private final ProximityProjectionKeysModel parent;
        private final Map<String, IBakedModel> cache;
        private final IModelTransform originalTransform;
        private final boolean isSideLit;

        BakedProximityProjectionKeysModel(ModelBakery bakery, IModelConfiguration owner, ProximityProjectionKeysModel parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms, Map<String, IBakedModel> cache, boolean untransformed, IModelTransform originalTransform, boolean isSideLit) {
            super(quads, particle, transforms, (ItemOverrideList)new ProximityProjectionKeysOverrideHandler(bakery), untransformed, isSideLit);
            this.owner = owner;
            this.parent = parent;
            this.cache = cache;
            this.originalTransform = originalTransform;
            this.isSideLit = isSideLit;
        }
    }

    private static final class ProximityProjectionKeysOverrideHandler
    extends ItemOverrideList {
        private final ModelBakery bakery;

        private ProximityProjectionKeysOverrideHandler(ModelBakery bakery) {
            this.bakery = bakery;
        }

        public IBakedModel func_209581_a(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
            BakedProximityProjectionKeysModel model = (BakedProximityProjectionKeysModel)originalModel;
            ProximityProjectionKeysModel parent = new ProximityProjectionKeysModel();
            IBakedModel bakedModel = parent.bake(model.owner, this.bakery, ModelLoader.defaultTextureGetter(), model.originalTransform, model.func_188617_f(), new ResourceLocation("mahoutsukai:proximity_projection_keys"));
            return bakedModel;
        }
    }

    public static enum Loader implements IModelLoader<ProximityProjectionKeysModel>
    {
        INSTANCE;


        public IResourceType getResourceType() {
            return VanillaResourceType.MODELS;
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        }

        public ProximityProjectionKeysModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new ProximityProjectionKeysModel();
        }
    }
}

