/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.BeaconTileEntityRenderer;
import net.minecraft.util.ResourceLocation;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffMahoujinEntity;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderMysticStaffMahoujinEntity
extends EntityRenderer<MysticStaffMahoujinEntity> {
    private static final ResourceLocation mahoujin = new ResourceLocation("mahoutsukai:textures/block/mahoujin_casting.png");

    public RenderMysticStaffMahoujinEntity(EntityRendererManager p_i46179_1_) {
        super(p_i46179_1_);
    }

    public ResourceLocation getEntityTexture(MysticStaffMahoujinEntity entity) {
        return AtlasTexture.field_110575_b;
    }

    public void render(MysticStaffMahoujinEntity entity, float eyaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight) {
        float prevYaw;
        matrix.func_227860_a_();
        int life = entity.getLife();
        float size = entity.getCircleSize();
        float yaw = entity.field_70177_z % 360.0f;
        float roll = entity.getRotationRoll();
        float pitch = entity.getRotationPitch();
        boolean renderBeam = entity.hasBeam();
        if (life < 20) {
            size = ((float)life + partialTicks) / 20.0f * size;
        }
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if ((prevYaw = entity.field_70126_B % 360.0f) < 0.0f) {
            prevYaw += 360.0f;
        }
        if (prevYaw - yaw > 300.0f) {
            yaw += 360.0f;
        }
        if (prevYaw - yaw < 300.0f && prevYaw - yaw > 0.0f) {
            prevYaw = yaw;
        }
        yaw = entity.field_70126_B + partialTicks * (yaw - prevYaw);
        matrix.func_227862_a_(size, size, size);
        RenderUtils.rotateQ(roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pitch, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
        RenderType type = MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, true);
        int lightmapX = 240;
        int lightmapY = 240;
        float[] colors = entity.getColor();
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = colors[3];
        IVertexBuilder bb = buffer.getBuffer(type);
        Matrix4f m = matrix.func_227866_c_().func_227870_a_();
        bb.func_227888_a_(m, -0.5f, 0.0f, -0.5f).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        bb.func_227888_a_(m, -0.5f, 0.0f, 0.5f).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        bb.func_227888_a_(m, 0.5f, 0.0f, 0.5f).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        bb.func_227888_a_(m, 0.5f, 0.0f, -0.5f).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        if (renderBeam) {
            float beamSize = MysticStaff.getBeamSize(entity, partialTicks);
            matrix.func_227862_a_(1.0f / size, 1.0f / size, 1.0f / size);
            matrix.func_227861_a_(-0.5, -0.5, -0.5);
            if (colors[1] < 0.26f) {
                colors[1] = (float)((double)colors[1] + 0.33);
            }
            BeaconTileEntityRenderer.func_228842_a_((MatrixStack)matrix, (IRenderTypeBuffer)buffer, (ResourceLocation)BeaconTileEntityRenderer.field_147523_b, (float)partialTicks, (float)1.0f, (long)entity.field_70170_p.func_82737_E(), (int)((int)entity.getBeamOffset()), (int)((int)entity.getBeamLength()), (float[])colors, (float)beamSize, (float)(beamSize + 0.2f));
        }
        matrix.func_227865_b_();
    }
}

