/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.expression;

import java.util.List;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.GenericName;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.type.IParsedType;

public class ParsedExpressionMember
extends ParsedExpression {
    private final ParsedExpression value;
    private final String member;
    private final List<IParsedType> genericParameters;

    public ParsedExpressionMember(CodePosition position, ParsedExpression value, String member, List<IParsedType> genericParameters) {
        super(position);
        this.value = value;
        this.member = member;
        this.genericParameters = genericParameters;
    }

    @Override
    public IPartialExpression compile(ExpressionScope scope) throws CompileException {
        StoredType[] typeArguments;
        IPartialExpression cValue = this.value.compile(scope.withoutHints());
        IPartialExpression member = cValue.getMember(this.position, scope, scope.hints, new GenericName(this.member, typeArguments = IParsedType.compileTypes(this.genericParameters, scope)));
        if (member == null) {
            throw new CompileException(this.position, CompileExceptionCode.NO_SUCH_MEMBER, "Member not found: " + this.member);
        }
        return member;
    }

    @Override
    public boolean hasStrongType() {
        return true;
    }
}

