/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javashared;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.Module;
import org.openzen.zenscript.codemodel.definition.EnumDefinition;
import org.openzen.zenscript.codemodel.definition.VariantDefinition;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.member.DefinitionMember;
import org.openzen.zenscript.codemodel.member.IDefinitionMember;
import org.openzen.zenscript.codemodel.member.ImplementationMember;
import org.openzen.zenscript.codemodel.member.ref.DefinitionMemberRef;
import org.openzen.zenscript.codemodel.member.ref.VariantOptionRef;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.FunctionTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.RangeTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.storage.BorrowStorageTag;
import org.openzen.zenscript.codemodel.type.storage.UniqueStorageTag;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaCompileSpace;
import org.openzen.zenscript.javashared.JavaCompiledModule;
import org.openzen.zenscript.javashared.JavaField;
import org.openzen.zenscript.javashared.JavaFunctionalInterfaceStorageTag;
import org.openzen.zenscript.javashared.JavaImplementation;
import org.openzen.zenscript.javashared.JavaMethod;
import org.openzen.zenscript.javashared.JavaNativeClass;
import org.openzen.zenscript.javashared.JavaSynthesizedClass;
import org.openzen.zenscript.javashared.JavaSynthesizedFunction;
import org.openzen.zenscript.javashared.JavaSynthesizedFunctionInstance;
import org.openzen.zenscript.javashared.JavaSynthesizedRange;
import org.openzen.zenscript.javashared.JavaSyntheticClassGenerator;
import org.openzen.zenscript.javashared.JavaSyntheticTypeSignatureConverter;
import org.openzen.zenscript.javashared.JavaTypeGenericVisitor;
import org.openzen.zenscript.javashared.JavaTypeInfo;
import org.openzen.zenscript.javashared.JavaVariantOption;

public abstract class JavaContext {
    private final GlobalTypeRegistry registry;
    private final Map<String, JavaSynthesizedFunction> functions = new HashMap<String, JavaSynthesizedFunction>();
    private final Map<String, JavaSynthesizedRange> ranges = new HashMap<String, JavaSynthesizedRange>();
    private boolean useShared = false;
    private final JavaCompileSpace space;
    private final Map<Module, JavaCompiledModule> modules = new HashMap<Module, JavaCompiledModule>();
    public final ZSPackage modulePackage;
    public final String basePackage;

    public JavaContext(JavaCompileSpace space, ZSPackage modulePackage, String basePackage) {
        this.space = space;
        this.registry = space.getRegistry();
        this.modulePackage = modulePackage;
        this.basePackage = basePackage;
        TypeParameter t = new TypeParameter(CodePosition.BUILTIN, "T");
        TypeParameter u = new TypeParameter(CodePosition.BUILTIN, "U");
        TypeParameter v = new TypeParameter(CodePosition.BUILTIN, "V");
        this.functions.put("TToU", new JavaSynthesizedFunction(new JavaClass("java.util.function", "Function", JavaClass.Kind.INTERFACE), new TypeParameter[]{t, u}, new FunctionHeader(this.registry.getGeneric(u).stored(BorrowStorageTag.INVOCATION), this.registry.getGeneric(t).stored(BorrowStorageTag.INVOCATION)), "apply"));
        this.functions.put("TUToV", new JavaSynthesizedFunction(new JavaClass("java.util.function", "BiFunction", JavaClass.Kind.INTERFACE), new TypeParameter[]{t, u, v}, new FunctionHeader(this.registry.getGeneric(v).stored(BorrowStorageTag.INVOCATION), this.registry.getGeneric(t).stored(BorrowStorageTag.INVOCATION), this.registry.getGeneric(u).stored(BorrowStorageTag.INVOCATION)), "apply"));
        this.functions.put("TToVoid", new JavaSynthesizedFunction(new JavaClass("java.util.function", "Consumer", JavaClass.Kind.INTERFACE), new TypeParameter[]{t}, new FunctionHeader(BasicTypeID.VOID.stored, this.registry.getGeneric(t).stored(BorrowStorageTag.INVOCATION)), "accept"));
        this.functions.put("TUToVoid", new JavaSynthesizedFunction(new JavaClass("java.util.function", "BiConsumer", JavaClass.Kind.INTERFACE), new TypeParameter[]{t, u}, new FunctionHeader(BasicTypeID.VOID.stored, this.registry.getGeneric(t).stored(BorrowStorageTag.INVOCATION), this.registry.getGeneric(u).stored(BorrowStorageTag.INVOCATION)), "accept"));
        this.functions.put("TToBool", new JavaSynthesizedFunction(new JavaClass("java.util.function", "Predicate", JavaClass.Kind.INTERFACE), new TypeParameter[]{t}, new FunctionHeader(BasicTypeID.BOOL.stored, this.registry.getGeneric(t).stored(BorrowStorageTag.INVOCATION)), "test"));
    }

    public String getPackageName(ZSPackage pkg) {
        if (pkg == null) {
            throw new IllegalArgumentException("Package not part of this module");
        }
        if (pkg == this.modulePackage) {
            return this.basePackage;
        }
        return this.getPackageName(pkg.parent) + "/" + pkg.name;
    }

    public JavaMethod getFunctionalInterface(StoredType type) {
        if (type.getSpecifiedStorage() instanceof JavaFunctionalInterfaceStorageTag) {
            JavaFunctionalInterfaceStorageTag tag = (JavaFunctionalInterfaceStorageTag)type.getSpecifiedStorage();
            return tag.method;
        }
        FunctionTypeID functionType = (FunctionTypeID)type.type;
        JavaSynthesizedFunctionInstance function = this.getFunction(functionType);
        return new JavaMethod(function.getCls(), JavaMethod.Kind.INTERFACE, function.getMethod(), false, this.getMethodDescriptor(function.getHeader()), 1025, function.getHeader().getReturnType().isGeneric());
    }

    protected abstract JavaSyntheticClassGenerator getTypeGenerator();

    public abstract String getDescriptor(TypeID var1);

    public abstract String getDescriptor(StoredType var1);

    public String getSignature(StoredType type) {
        return new JavaTypeGenericVisitor(this).getGenericSignature(type);
    }

    public void addModule(Module module, JavaCompiledModule target) {
        this.modules.put(module, target);
        this.space.register(target);
    }

    public JavaCompiledModule getJavaModule(Module module) {
        if (this.modules.containsKey(module)) {
            return this.modules.get(module);
        }
        JavaCompiledModule javaModule = this.space.getCompiled(module);
        if (javaModule == null) {
            throw new IllegalStateException("Module not yet registered: " + module.name);
        }
        return javaModule;
    }

    public JavaClass getJavaClass(HighLevelDefinition definition) {
        return this.getJavaModule(definition.module).getClassInfo(definition);
    }

    public JavaClass getJavaExpansionClass(HighLevelDefinition definition) {
        return this.getJavaModule(definition.module).getExpansionClassInfo(definition);
    }

    public JavaClass optJavaClass(HighLevelDefinition definition) {
        return this.getJavaModule(definition.module).optClassInfo(definition);
    }

    public JavaNativeClass getJavaNativeClass(HighLevelDefinition definition) {
        return this.getJavaModule(definition.module).getNativeClassInfo(definition);
    }

    public boolean hasJavaClass(HighLevelDefinition definition) {
        return this.getJavaModule(definition.module).hasClassInfo(definition);
    }

    public void setJavaClass(HighLevelDefinition definition, JavaClass cls) {
        this.getJavaModule(definition.module).setClassInfo(definition, cls);
    }

    public void setJavaExpansionClass(HighLevelDefinition definition, JavaClass cls) {
        this.getJavaModule(definition.module).setExpansionClassInfo(definition, cls);
    }

    public void setJavaNativeClass(HighLevelDefinition definition, JavaNativeClass cls) {
        this.getJavaModule(definition.module).setNativeClassInfo(definition, cls);
    }

    public boolean hasJavaField(DefinitionMemberRef member) {
        HighLevelDefinition definition = member.getTarget().getDefinition();
        return this.getJavaModule(definition.module).optFieldInfo(member.getTarget()) != null;
    }

    public JavaField getJavaField(IDefinitionMember member) {
        HighLevelDefinition definition = member.getDefinition();
        return this.getJavaModule(definition.module).getFieldInfo(member);
    }

    public JavaField getJavaField(DefinitionMemberRef member) {
        return this.getJavaField(member.getTarget());
    }

    public JavaMethod getJavaMethod(IDefinitionMember member) {
        HighLevelDefinition definition = member.getDefinition();
        return this.getJavaModule(definition.module).getMethodInfo(member);
    }

    public JavaMethod getJavaMethod(DefinitionMemberRef member) {
        return this.getJavaMethod(member.getTarget());
    }

    public JavaVariantOption getJavaVariantOption(VariantDefinition.Option option) {
        VariantDefinition definition = option.variant;
        return this.getJavaModule(definition.module).getVariantOption(option);
    }

    public JavaVariantOption getJavaVariantOption(VariantOptionRef member) {
        return this.getJavaVariantOption(member.getOption());
    }

    public JavaImplementation getJavaImplementation(ImplementationMember member) {
        return this.getJavaModule(member.definition.module).getImplementationInfo(member);
    }

    public void useShared() {
        if (this.useShared) {
            return;
        }
        this.useShared = true;
        this.getTypeGenerator().synthesizeShared();
    }

    public String getMethodDescriptor(FunctionHeader header) {
        return this.getMethodDescriptor(header, false, "");
    }

    public String getMethodDescriptorExpansion(FunctionHeader header, StoredType expandedType) {
        StringBuilder startBuilder = new StringBuilder(this.getDescriptor(expandedType));
        ArrayList<TypeParameter> typeParameters = new ArrayList<TypeParameter>();
        expandedType.type.extractTypeParameters(typeParameters);
        for (TypeParameter typeParameter : typeParameters) {
            startBuilder.append("Ljava/lang/Class;");
        }
        return this.getMethodDescriptor(header, false, startBuilder.toString());
    }

    public String getMethodSignatureExpansion(FunctionHeader header, StoredType expandedClass) {
        return new JavaTypeGenericVisitor(this).getMethodSignatureExpansion(header, expandedClass);
    }

    public String getMethodSignature(FunctionHeader header) {
        return this.getMethodSignature(header, true);
    }

    public String getMethodSignature(FunctionHeader header, boolean withGenerics) {
        return new JavaTypeGenericVisitor(this).getGenericMethodSignature(header, withGenerics);
    }

    public String getEnumConstructorDescriptor(FunctionHeader header) {
        return this.getMethodDescriptor(header, true, "");
    }

    public JavaSynthesizedFunctionInstance getFunction(FunctionTypeID type) {
        JavaSynthesizedFunction function;
        String id = this.getFunctionId(type.header);
        if (!this.functions.containsKey(id)) {
            StoredType returnType;
            JavaClass cls = new JavaClass("zsynthetic", "Function" + id, JavaClass.Kind.INTERFACE);
            ArrayList<TypeParameter> typeParameters = new ArrayList<TypeParameter>();
            ArrayList<FunctionParameter> parameters = new ArrayList<FunctionParameter>();
            for (FunctionParameter parameter : type.header.parameters) {
                JavaTypeInfo typeInfo = JavaTypeInfo.get(parameter.type);
                if (typeInfo.primitive) {
                    parameters.add(new FunctionParameter(parameter.type, Character.toString((char)(97 + parameters.size()))));
                    continue;
                }
                TypeParameter typeParameter = new TypeParameter(CodePosition.BUILTIN, this.getTypeParameter(typeParameters.size()));
                typeParameters.add(typeParameter);
                parameters.add(new FunctionParameter(this.registry.getGeneric(typeParameter).stored(BorrowStorageTag.INVOCATION), Character.toString((char)(97 + parameters.size()))));
            }
            JavaTypeInfo typeInfo = JavaTypeInfo.get(type.header.getReturnType());
            if (typeInfo.primitive) {
                returnType = type.header.getReturnType();
            } else {
                TypeParameter typeParameter = new TypeParameter(CodePosition.BUILTIN, this.getTypeParameter(typeParameters.size()));
                typeParameters.add(typeParameter);
                returnType = this.registry.getGeneric(typeParameter).stored(UniqueStorageTag.INSTANCE);
            }
            function = new JavaSynthesizedFunction(cls, typeParameters.toArray(new TypeParameter[typeParameters.size()]), new FunctionHeader(returnType, parameters.toArray(new FunctionParameter[parameters.size()])), "invoke");
            this.functions.put(id, function);
            this.getTypeGenerator().synthesizeFunction(function);
        } else {
            function = this.functions.get(id);
        }
        ArrayList<TypeID> typeArguments = new ArrayList<TypeID>();
        for (FunctionParameter parameter : type.header.parameters) {
            JavaTypeInfo typeInfo = JavaTypeInfo.get(parameter.type);
            if (typeInfo.primitive) continue;
            typeArguments.add(parameter.type.type);
        }
        if (!JavaTypeInfo.isPrimitive(type.header.getReturnType())) {
            typeArguments.add(type.header.getReturnType().type);
        }
        return new JavaSynthesizedFunctionInstance(function, typeArguments.toArray(new TypeID[typeArguments.size()]));
    }

    private String getFunctionId(FunctionHeader header) {
        StringBuilder signature = new StringBuilder();
        int typeParameterIndex = 0;
        for (FunctionParameter parameter : header.parameters) {
            JavaTypeInfo typeInfo = JavaTypeInfo.get(parameter.type);
            String id = typeInfo.primitive ? parameter.type.type.accept(parameter.type, new JavaSyntheticTypeSignatureConverter()) : this.getTypeParameter(typeParameterIndex++);
            signature.append(id);
        }
        signature.append("To");
        JavaTypeInfo typeInfo = JavaTypeInfo.get(header.getReturnType());
        String id = typeInfo.primitive ? header.getReturnType().type.accept(header.getReturnType(), new JavaSyntheticTypeSignatureConverter()) : this.getTypeParameter(typeParameterIndex++);
        signature.append(id);
        return signature.toString();
    }

    private String getTypeParameter(int index) {
        switch (index) {
            case 0: {
                return "T";
            }
            case 1: {
                return "U";
            }
            case 2: {
                return "V";
            }
            case 3: {
                return "W";
            }
            case 4: {
                return "X";
            }
            case 5: {
                return "Y";
            }
            case 6: {
                return "Z";
            }
        }
        return "T" + index;
    }

    public JavaSynthesizedClass getRange(RangeTypeID type) {
        JavaSynthesizedRange range;
        String id;
        JavaTypeInfo typeInfo = JavaTypeInfo.get(type.baseType);
        String string = id = typeInfo.primitive ? type.accept(null, new JavaSyntheticTypeSignatureConverter()) : "T";
        if (!this.ranges.containsKey(id)) {
            JavaClass cls = new JavaClass("zsynthetic", id, JavaClass.Kind.CLASS);
            if (typeInfo.primitive) {
                range = new JavaSynthesizedRange(cls, TypeParameter.NONE, type.baseType);
            } else {
                TypeParameter typeParameter = new TypeParameter(CodePosition.BUILTIN, "T");
                range = new JavaSynthesizedRange(cls, new TypeParameter[]{typeParameter}, this.registry.getGeneric(typeParameter).stored(BorrowStorageTag.INVOCATION));
            }
            this.ranges.put(id, range);
            this.getTypeGenerator().synthesizeRange(range);
        } else {
            range = this.ranges.get(id);
        }
        if (typeInfo.primitive) {
            return new JavaSynthesizedClass(range.cls, TypeID.NONE);
        }
        return new JavaSynthesizedClass(range.cls, new TypeID[]{type.baseType.type});
    }

    public String getMethodDescriptor(FunctionHeader header, boolean isEnumConstructor, String expandedType) {
        StringBuilder descBuilder = new StringBuilder("(");
        for (int i = 0; i < header.getNumberOfTypeParameters(); ++i) {
            descBuilder.append("Ljava/lang/Class;");
        }
        if (isEnumConstructor) {
            descBuilder.append("Ljava/lang/String;I");
        }
        if (expandedType != null) {
            descBuilder.append(expandedType);
        }
        for (FunctionParameter parameter : header.parameters) {
            descBuilder.append(this.getDescriptor(parameter.type));
        }
        descBuilder.append(")");
        descBuilder.append(this.getDescriptor(header.getReturnType()));
        return descBuilder.toString();
    }

    public String getMethodDescriptorConstructor(FunctionHeader header, DefinitionMember member) {
        StringBuilder startBuilder = new StringBuilder();
        for (TypeParameter typeParameter : member.definition.typeParameters) {
            startBuilder.append("Ljava/lang/Class;");
        }
        return this.getMethodDescriptor(header, member.definition instanceof EnumDefinition, startBuilder.toString());
    }
}

