/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type.member;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.CompareType;
import org.openzen.zenscript.codemodel.GenericName;
import org.openzen.zenscript.codemodel.OperatorType;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.CheckNullExpression;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.InterfaceCastExpression;
import org.openzen.zenscript.codemodel.expression.InvalidExpression;
import org.openzen.zenscript.codemodel.expression.NullExpression;
import org.openzen.zenscript.codemodel.expression.StorageCastExpression;
import org.openzen.zenscript.codemodel.expression.SupertypeCastExpression;
import org.openzen.zenscript.codemodel.expression.WrapOptionalExpression;
import org.openzen.zenscript.codemodel.member.EnumConstantMember;
import org.openzen.zenscript.codemodel.member.IDefinitionMember;
import org.openzen.zenscript.codemodel.member.InnerDefinition;
import org.openzen.zenscript.codemodel.member.ref.CasterMemberRef;
import org.openzen.zenscript.codemodel.member.ref.ConstMemberRef;
import org.openzen.zenscript.codemodel.member.ref.DefinitionMemberRef;
import org.openzen.zenscript.codemodel.member.ref.FieldMemberRef;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.member.ref.GetterMemberRef;
import org.openzen.zenscript.codemodel.member.ref.ImplementationMemberRef;
import org.openzen.zenscript.codemodel.member.ref.IteratorMemberRef;
import org.openzen.zenscript.codemodel.member.ref.SetterMemberRef;
import org.openzen.zenscript.codemodel.member.ref.VariantOptionRef;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.partial.PartialMemberGroupExpression;
import org.openzen.zenscript.codemodel.partial.PartialStaticMemberGroupExpression;
import org.openzen.zenscript.codemodel.partial.PartialTypeExpression;
import org.openzen.zenscript.codemodel.partial.PartialVariantOptionExpression;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.type.ArrayTypeID;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.GenericTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.InvalidTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.member.BuiltinID;
import org.openzen.zenscript.codemodel.type.member.LocalMemberCache;
import org.openzen.zenscript.codemodel.type.member.TagRemovingTypeVisitor;
import org.openzen.zenscript.codemodel.type.member.TypeMember;
import org.openzen.zenscript.codemodel.type.member.TypeMemberGroup;
import org.openzen.zenscript.codemodel.type.member.TypeMemberPriority;

public final class TypeMembers {
    private final LocalMemberCache cache;
    public final StoredType type;
    private final List<TypeMember<CasterMemberRef>> casters = new ArrayList<TypeMember<CasterMemberRef>>();
    private final List<TypeMember<ImplementationMemberRef>> implementations = new ArrayList<TypeMember<ImplementationMemberRef>>();
    private final List<TypeMember<IteratorMemberRef>> iterators = new ArrayList<TypeMember<IteratorMemberRef>>();
    private final Map<String, EnumConstantMember> enumMembers = new HashMap<String, EnumConstantMember>();
    private final Map<String, VariantOptionRef> variantOptions = new HashMap<String, VariantOptionRef>();
    private final Map<String, TypeMemberGroup> members = new HashMap<String, TypeMemberGroup>();
    private final Map<String, InnerDefinition> innerTypes = new HashMap<String, InnerDefinition>();
    private final Map<OperatorType, TypeMemberGroup> operators = new HashMap<OperatorType, TypeMemberGroup>();

    public TypeMembers(LocalMemberCache cache, StoredType type) {
        if (type == null) {
            throw new NullPointerException("Type must not be null!");
        }
        if (type.type == BasicTypeID.UNDETERMINED) {
            throw new IllegalArgumentException("Cannot retrieve members of undetermined type");
        }
        this.cache = cache;
        this.type = type;
    }

    public LocalMemberCache getMemberCache() {
        return this.cache;
    }

    public boolean extendsOrImplements(TypeID other) {
        TypeID superType;
        block9: {
            other = other.getNormalized();
            if (this.type.type instanceof DefinitionTypeID && other instanceof DefinitionTypeID) {
                DefinitionTypeID thisTypeId = (DefinitionTypeID)this.type.type;
                DefinitionTypeID otherTypeId = (DefinitionTypeID)other;
                if (thisTypeId.definition == otherTypeId.definition && thisTypeId.definition.typeParameters.length == otherTypeId.typeArguments.length) {
                    for (int i = 0; i < thisTypeId.definition.typeParameters.length; ++i) {
                        TypeID type = otherTypeId.typeArguments[i].type;
                        if (type == BasicTypeID.UNDETERMINED || type instanceof InvalidTypeID && ((InvalidTypeID)type).code == CompileExceptionCode.TYPE_ARGUMENTS_NOT_INFERRABLE || thisTypeId.definition.typeParameters[i].matches(this.cache, type)) {
                            continue;
                        }
                        break block9;
                    }
                    return true;
                }
            }
        }
        if ((superType = this.type.type.getSuperType(this.cache.getRegistry())) != null) {
            if (superType == other) {
                return true;
            }
            if (this.cache.get(superType.stored(this.type.getActualStorage())).extendsOrImplements(other)) {
                return true;
            }
        }
        for (TypeMember<ImplementationMemberRef> implementation : this.implementations) {
            if (((ImplementationMemberRef)implementation.member).implementsType.type == other) {
                return true;
            }
            if (!this.cache.get(((ImplementationMemberRef)implementation.member).implementsType).extendsOrImplements(other)) continue;
            return true;
        }
        return false;
    }

    public boolean extendsType(TypeID other) {
        other = other.getNormalized();
        TypeID superType = this.type.type.getSuperType(this.cache.getRegistry());
        if (superType != null) {
            if (superType == other) {
                return true;
            }
            if (this.cache.get(superType.stored(this.type.getActualStorage())).extendsType(other)) {
                return true;
            }
        }
        return false;
    }

    public GlobalTypeRegistry getTypeRegistry() {
        return this.cache.getRegistry();
    }

    public void copyMembersTo(TypeMembers other, TypeMemberPriority priority) {
        other.casters.addAll(this.casters);
        other.iterators.addAll(this.iterators);
        for (Map.Entry<String, EnumConstantMember> entry : this.enumMembers.entrySet()) {
            other.addEnumMember(entry.getValue(), priority);
        }
        for (Map.Entry<String, Object> entry : this.variantOptions.entrySet()) {
            other.addVariantOption((VariantOptionRef)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.members.entrySet()) {
            other.getOrCreateGroup(entry.getKey(), ((TypeMemberGroup)entry.getValue()).isStatic).merge((TypeMemberGroup)entry.getValue(), priority);
        }
        for (Map.Entry<String, Object> entry : this.innerTypes.entrySet()) {
            other.innerTypes.put(entry.getKey(), (InnerDefinition)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.operators.entrySet()) {
            other.getOrCreateGroup((OperatorType)((Object)entry.getKey())).merge((TypeMemberGroup)entry.getValue(), priority);
        }
    }

    public DefinitionMemberRef getBuiltin(BuiltinID builtin) {
        for (TypeMemberGroup group : this.members.values()) {
            if (group.getConstant() != null && group.getConstant().member.builtin == builtin) {
                return group.getConstant();
            }
            if (group.getField() != null && group.getField().member.builtin == builtin) {
                return group.getField();
            }
            for (TypeMember<FunctionalMemberRef> member : group.getMethodMembers()) {
                if (((FunctionalMemberRef)member.member).getBuiltin() != builtin) continue;
                return member.member;
            }
        }
        for (TypeMemberGroup group : this.operators.values()) {
            if (group.getConstant() != null && group.getConstant().member.builtin == builtin) {
                return group.getConstant();
            }
            if (group.getField() != null && group.getField().member.builtin == builtin) {
                return group.getField();
            }
            for (TypeMember<FunctionalMemberRef> member : group.getMethodMembers()) {
                if (((FunctionalMemberRef)member.member).getBuiltin() != builtin) continue;
                return member.member;
            }
        }
        return null;
    }

    public StoredType union(StoredType other) {
        StoredType union;
        if (this.type == (other = other.getNormalized())) {
            return this.type;
        }
        if (this.canCastImplicit(other)) {
            return other;
        }
        if (this.cache.get(other).canCastImplicit(this.type)) {
            return this.type;
        }
        for (TypeMember<ImplementationMemberRef> implementation : this.implementations) {
            union = this.cache.get(((ImplementationMemberRef)implementation.member).implementsType).union(other);
            if (union == null) continue;
            return union;
        }
        if (this.type.type instanceof ArrayTypeID && other.type instanceof ArrayTypeID) {
            ArrayTypeID thisArray = (ArrayTypeID)this.type.type;
            ArrayTypeID otherArray = (ArrayTypeID)other.type;
            if (thisArray.dimension == otherArray.dimension && (union = this.cache.get(thisArray.elementType).union(otherArray.elementType)) != null) {
                return this.getTypeRegistry().getArray(union, thisArray.dimension).stored();
            }
        }
        return null;
    }

    public List<IDefinitionMember> getUnimplementedMembers(Set<IDefinitionMember> implemented) {
        TypeMemberGroup group;
        ArrayList<IDefinitionMember> result = new ArrayList<IDefinitionMember>();
        for (TypeMember<CasterMemberRef> typeMember : this.casters) {
            if (!((CasterMemberRef)typeMember.member).member.isAbstract() || implemented.contains(((CasterMemberRef)typeMember.member).member)) continue;
            result.add(((CasterMemberRef)typeMember.member).member);
        }
        for (TypeMember<DefinitionMemberRef> typeMember : this.iterators) {
            if (!((IteratorMemberRef)typeMember.member).target.isAbstract() || implemented.contains(((IteratorMemberRef)typeMember.member).target)) continue;
            result.add(((IteratorMemberRef)typeMember.member).target);
        }
        for (Map.Entry entry : this.members.entrySet()) {
            group = (TypeMemberGroup)entry.getValue();
            if (group.getGetter() != null && group.getGetter().member.isAbstract() && !implemented.contains(group.getGetter().member)) {
                result.add(group.getGetter().member);
            }
            if (group.getSetter() != null && group.getSetter().member.isAbstract() && !implemented.contains(group.getSetter().member)) {
                result.add(group.getSetter().member);
            }
            for (TypeMember<FunctionalMemberRef> member : group.getMethodMembers()) {
                if (!((FunctionalMemberRef)member.member).getTarget().isAbstract() || implemented.contains(((FunctionalMemberRef)member.member).getTarget())) continue;
                result.add(((FunctionalMemberRef)member.member).getTarget());
            }
        }
        for (Map.Entry entry : this.operators.entrySet()) {
            if (entry.getKey() == OperatorType.DESTRUCTOR) continue;
            group = (TypeMemberGroup)entry.getValue();
            if (group.getGetter() != null && group.getGetter().member.isAbstract() && !implemented.contains(group.getGetter().member)) {
                result.add(group.getGetter().member);
            }
            if (group.getSetter() != null && group.getSetter().member.isAbstract() && !implemented.contains(group.getSetter().member)) {
                result.add(group.getSetter().member);
            }
            for (TypeMember<FunctionalMemberRef> member : group.getMethodMembers()) {
                if (!((FunctionalMemberRef)member.member).getTarget().isAbstract() || implemented.contains(((FunctionalMemberRef)member.member).getTarget())) continue;
                result.add(((FunctionalMemberRef)member.member).getTarget());
            }
        }
        return result;
    }

    public void addConstructor(FunctionalMemberRef constructor, TypeMemberPriority priority) {
        this.getOrCreateGroup(OperatorType.CONSTRUCTOR).addMethod(constructor, priority);
    }

    public void addConstructor(FunctionalMemberRef constructor) {
        this.getOrCreateGroup(OperatorType.CONSTRUCTOR).addMethod(constructor, TypeMemberPriority.SPECIFIED);
    }

    public void addDestructor(FunctionalMemberRef destructor, TypeMemberPriority priority) {
        this.getOrCreateGroup(OperatorType.DESTRUCTOR).addMethod(destructor, priority);
    }

    public void addCaller(FunctionalMemberRef caller, TypeMemberPriority priority) {
        this.getOrCreateGroup(OperatorType.CALL).addMethod(caller, priority);
    }

    public void addCaster(CasterMemberRef caster) throws CompileException {
        this.addCaster(caster, TypeMemberPriority.SPECIFIED);
    }

    public void addCaster(CasterMemberRef caster, TypeMemberPriority priority) {
        for (int i = 0; i < this.casters.size(); ++i) {
            if (((CasterMemberRef)this.casters.get((int)i).member).toType != caster.toType) continue;
            this.casters.set(i, this.casters.get(i).resolve(new TypeMember<CasterMemberRef>(priority, caster)));
        }
        this.casters.add(new TypeMember<CasterMemberRef>(priority, caster));
    }

    public void addConst(ConstMemberRef member) {
        TypeMemberGroup group = this.getOrCreateGroup(member.member.name, true);
        group.setConst(member, TypeMemberPriority.SPECIFIED);
    }

    public void addField(FieldMemberRef member) {
        this.addField(member, TypeMemberPriority.SPECIFIED);
    }

    public void addField(FieldMemberRef member, TypeMemberPriority priority) {
        TypeMemberGroup group = this.getOrCreateGroup(member.member.name, member.isStatic());
        group.setField(member, priority);
    }

    public void addGetter(GetterMemberRef member, TypeMemberPriority priority) {
        TypeMemberGroup group = this.getOrCreateGroup(member.member.name, member.isStatic());
        group.setGetter(member, priority);
    }

    public void addSetter(SetterMemberRef member, TypeMemberPriority priority) {
        TypeMemberGroup group = this.getOrCreateGroup(member.member.name, member.isStatic());
        group.setSetter(member, priority);
    }

    public void addMethod(String name, FunctionalMemberRef member, TypeMemberPriority priority) {
        TypeMemberGroup group = this.getOrCreateGroup(name, member.isStatic());
        group.addMethod(member, priority);
    }

    public void addOperator(OperatorType operator, FunctionalMemberRef member) {
        this.addOperator(operator, member, TypeMemberPriority.SPECIFIED);
    }

    public boolean hasOperator(OperatorType operator) {
        return this.operators.containsKey((Object)operator) && this.operators.get((Object)operator).hasMethods();
    }

    public void addOperator(OperatorType operator, FunctionalMemberRef member, TypeMemberPriority priority) {
        TypeMemberGroup group = this.getOrCreateGroup(operator);
        group.addMethod(member, priority);
    }

    public void addVariantOption(VariantOptionRef option) {
        this.variantOptions.put(option.getName(), option);
    }

    public void addIterator(IteratorMemberRef iterator, TypeMemberPriority priority) {
        for (int i = 0; i < this.iterators.size(); ++i) {
            if (((IteratorMemberRef)this.iterators.get((int)i).member).getLoopVariableCount() != iterator.getLoopVariableCount()) continue;
            this.iterators.set(i, this.iterators.get(i).resolve(new TypeMember<IteratorMemberRef>(priority, iterator)));
            return;
        }
        this.iterators.add(new TypeMember<IteratorMemberRef>(priority, iterator));
    }

    public void addImplementation(ImplementationMemberRef member, TypeMemberPriority priority) {
        for (int i = 0; i < this.implementations.size(); ++i) {
            if (((ImplementationMemberRef)this.implementations.get((int)i).member).implementsType != member.implementsType) continue;
            this.implementations.set(i, this.implementations.get(i).resolve(new TypeMember<ImplementationMemberRef>(priority, member)));
            return;
        }
        this.implementations.add(new TypeMember<ImplementationMemberRef>(priority, member));
    }

    public void addInnerType(String name, InnerDefinition type) {
        this.innerTypes.put(name, type);
    }

    public TypeMemberGroup getOrCreateGroup(String name, boolean isStatic) {
        if (!this.members.containsKey(name)) {
            this.members.put(name, new TypeMemberGroup(isStatic, name));
        }
        return this.members.get(name);
    }

    public TypeMemberGroup getGroup(String name) {
        if (!this.members.containsKey(name)) {
            return new TypeMemberGroup(false, name);
        }
        return this.members.get(name);
    }

    public TypeMemberGroup getOrCreateGroup(OperatorType operator) {
        if (!this.operators.containsKey((Object)operator)) {
            this.operators.put(operator, new TypeMemberGroup(false, operator.operator + " operator"));
        }
        return this.operators.get((Object)operator);
    }

    public TypeMemberGroup getGroup(OperatorType operator) {
        if (!this.operators.containsKey((Object)operator)) {
            return new TypeMemberGroup(false, operator.operator + " operator");
        }
        return this.operators.get((Object)operator);
    }

    public void addEnumMember(EnumConstantMember member, TypeMemberPriority priority) {
        this.enumMembers.put(member.name, member);
    }

    public EnumConstantMember getEnumMember(String name) {
        return this.enumMembers.get(name);
    }

    public VariantOptionRef getVariantOption(String name) {
        return this.variantOptions.get(name);
    }

    public Expression compare(CodePosition position, TypeScope scope, CompareType operator, Expression left, Expression right) throws CompileException {
        TypeMemberGroup equal;
        if (operator == CompareType.EQ) {
            equal = this.getOrCreateGroup(OperatorType.EQUALS);
            for (TypeMember<FunctionalMemberRef> member : equal.getMethodMembers()) {
                if (!((FunctionalMemberRef)member.member).getHeader().accepts(scope, right)) continue;
                return equal.call(position, scope, left, new CallArguments(right), false);
            }
        } else if (operator == CompareType.NE) {
            equal = this.getOrCreateGroup(OperatorType.NOTEQUALS);
            for (TypeMember<FunctionalMemberRef> member : equal.getMethodMembers()) {
                if (!((FunctionalMemberRef)member.member).getHeader().accepts(scope, right)) continue;
                return equal.call(position, scope, left, new CallArguments(right), false);
            }
        }
        TypeMemberGroup compare = this.getOrCreateGroup(OperatorType.COMPARE);
        return compare.callWithComparator(position, scope, left, new CallArguments(right), operator);
    }

    public Expression unary(CodePosition position, TypeScope scope, OperatorType operator, Expression value) throws CompileException {
        TypeMemberGroup members = this.getOrCreateGroup(operator);
        return members.call(position, scope, value, new CallArguments(Expression.NONE), false);
    }

    public IteratorMemberRef getIterator(int variables) {
        for (TypeMember<IteratorMemberRef> iterator : this.iterators) {
            if (((IteratorMemberRef)iterator.member).getLoopVariableCount() != variables) continue;
            return (IteratorMemberRef)iterator.member;
        }
        return null;
    }

    public StoredType[] getLoopTypes(int variables) {
        for (TypeMember<IteratorMemberRef> iterator : this.iterators) {
            if (((IteratorMemberRef)iterator.member).getLoopVariableCount() != variables) continue;
            return ((IteratorMemberRef)iterator.member).types;
        }
        return null;
    }

    public boolean canCastImplicit(StoredType toType) {
        if (this.areEquivalent(this.type, toType = toType.getNormalized())) {
            return true;
        }
        if (toType.type == BasicTypeID.UNDETERMINED) {
            throw new IllegalArgumentException("Cannot cast to undetermined type!");
        }
        if (this.type.type == BasicTypeID.NULL && toType.type.isOptional()) {
            return true;
        }
        if (!this.type.getActualStorage().canCastTo(toType.getActualStorage()) && !toType.getActualStorage().canCastFrom(this.type.getActualStorage())) {
            return false;
        }
        if (toType.isOptional() && this.canCastImplicit(toType.withoutOptional())) {
            return true;
        }
        if (this.type.isOptional() && this.areEquivalent(this.type.withoutOptional(), toType)) {
            return true;
        }
        if (this.getImplicitCaster(toType) != null || this.extendsOrImplements(toType.type)) {
            return true;
        }
        if (this.type.type.isGeneric() && this.type.type instanceof GenericTypeID) {
            GenericTypeID genericTypeID = (GenericTypeID)this.type.type;
            if (genericTypeID.parameter.matches(this.cache, toType.type)) {
                return true;
            }
        }
        StoredType accept = this.type.type.accept(new TagRemovingTypeVisitor(this.cache));
        return !this.type.type.equals(accept.type) && this.cache.get(accept).canCastImplicit(toType);
    }

    private boolean areEquivalent(StoredType fromType, StoredType toType) {
        if (fromType == toType || fromType.equals(toType)) {
            return true;
        }
        if (!fromType.getActualStorage().canCastTo(toType.getActualStorage()) && !toType.getActualStorage().canCastFrom(fromType.getActualStorage())) {
            return false;
        }
        return fromType.type.equals(toType.type);
    }

    public CasterMemberRef getImplicitCaster(StoredType toType) {
        toType = toType.getNormalized();
        for (TypeMember<CasterMemberRef> caster : this.casters) {
            if (!((CasterMemberRef)caster.member).isImplicit() || !this.areEquivalent(((CasterMemberRef)caster.member).toType, toType)) continue;
            return (CasterMemberRef)caster.member;
        }
        return null;
    }

    public CasterMemberRef getCaster(StoredType toType) {
        toType = toType.getNormalized();
        for (TypeMember<CasterMemberRef> caster : this.casters) {
            if (!this.areEquivalent(((CasterMemberRef)caster.member).toType, toType)) continue;
            return (CasterMemberRef)caster.member;
        }
        return null;
    }

    public boolean canCast(StoredType toType) {
        if (this.canCastImplicit(toType = toType.getNormalized())) {
            return true;
        }
        for (TypeMember<CasterMemberRef> caster : this.casters) {
            if (!this.areEquivalent(((CasterMemberRef)caster.member).toType, toType)) continue;
            return true;
        }
        return false;
    }

    public Map<DefinitionMemberRef, IDefinitionMember> borrowInterfaceMembersFromDefinition(Set<IDefinitionMember> implemented, TypeMembers definitionMembers) {
        FunctionalMemberRef functional;
        TypeMemberGroup definitionGroup;
        TypeMemberGroup group;
        DefinitionMemberRef implementation;
        HashMap<DefinitionMemberRef, IDefinitionMember> result = new HashMap<DefinitionMemberRef, IDefinitionMember>();
        for (TypeMember<CasterMemberRef> typeMember : this.casters) {
            if (implemented.contains(((CasterMemberRef)typeMember.member).member) || (implementation = definitionMembers.getCaster(((CasterMemberRef)typeMember.member).toType)) == null) continue;
            result.put((DefinitionMemberRef)typeMember.member, ((CasterMemberRef)implementation).getTarget());
        }
        for (TypeMember<DefinitionMemberRef> typeMember : this.iterators) {
            if (implemented.contains(((IteratorMemberRef)typeMember.member).target) || (implementation = definitionMembers.getIterator(((IteratorMemberRef)typeMember.member).getLoopVariableCount())) == null) continue;
            result.put((DefinitionMemberRef)typeMember.member, ((IteratorMemberRef)implementation).getTarget());
        }
        for (Map.Entry entry : this.members.entrySet()) {
            SetterMemberRef implementation2;
            GetterMemberRef implementation22;
            group = (TypeMemberGroup)entry.getValue();
            definitionGroup = definitionMembers.getGroup((String)entry.getKey());
            if (definitionGroup == null) continue;
            if (group.getGetter() != null && !implemented.contains(group.getGetter().member) && (implementation22 = definitionGroup.getGetter()) != null) {
                result.put(group.getGetter(), implementation22.getTarget());
            }
            if (group.getSetter() != null && !implemented.contains(group.getSetter().member) && (implementation2 = definitionGroup.getSetter()) != null) {
                result.put(group.getSetter(), implementation2.getTarget());
            }
            for (TypeMember<FunctionalMemberRef> member : group.getMethodMembers()) {
                if (implemented.contains(((FunctionalMemberRef)member.member).getTarget()) || (functional = definitionGroup.getMethod(((FunctionalMemberRef)member.member).getHeader())) == null) continue;
                result.put((DefinitionMemberRef)member.member, functional.getTarget());
            }
        }
        for (Map.Entry entry : this.operators.entrySet()) {
            if (entry.getKey() == OperatorType.DESTRUCTOR) continue;
            group = (TypeMemberGroup)entry.getValue();
            definitionGroup = definitionMembers.getGroup((OperatorType)((Object)entry.getKey()));
            if (definitionGroup == null) continue;
            for (TypeMember<FunctionalMemberRef> member : group.getMethodMembers()) {
                if (implemented.contains(((FunctionalMemberRef)member.member).getTarget()) || (functional = definitionGroup.getMethod(((FunctionalMemberRef)member.member).getHeader())) == null) continue;
                result.put((DefinitionMemberRef)member.member, functional.getTarget());
            }
        }
        return result;
    }

    private Expression castEquivalent(CodePosition position, Expression value, StoredType toType) {
        if (toType.equals(value.type)) {
            return value;
        }
        return new StorageCastExpression(position, value, toType);
    }

    public Expression castImplicit(CodePosition position, Expression value, StoredType toType, boolean implicit) {
        if (toType == null) {
            throw new NullPointerException();
        }
        toType = toType.getNormalized();
        if (toType.type == BasicTypeID.UNDETERMINED) {
            return value;
        }
        if (this.areEquivalent(this.type, toType)) {
            return this.castEquivalent(position, value, toType);
        }
        if (this.type.type == BasicTypeID.NULL && toType.isOptional()) {
            return new NullExpression(position, toType);
        }
        if (toType.isOptional() && this.canCastImplicit(toType.withoutOptional())) {
            return this.castEquivalent(position, new WrapOptionalExpression(position, this.castImplicit(position, value, toType.withoutOptional(), implicit), toType), toType);
        }
        if (this.type.isOptional() && this.areEquivalent(this.type.withoutOptional(), toType)) {
            return this.castEquivalent(position, new CheckNullExpression(position, value), toType);
        }
        for (TypeMember<CasterMemberRef> typeMember : this.casters) {
            if (!((CasterMemberRef)typeMember.member).isImplicit() || !this.areEquivalent(((CasterMemberRef)typeMember.member).toType, toType)) continue;
            return this.castEquivalent(position, ((CasterMemberRef)typeMember.member).cast(position, value, implicit), toType);
        }
        for (TypeMember<DefinitionMemberRef> typeMember : this.implementations) {
            if (((ImplementationMemberRef)typeMember.member).implementsType.type.getNormalized() != toType.type) continue;
            return this.castEquivalent(position, new InterfaceCastExpression(position, value, (ImplementationMemberRef)typeMember.member), toType);
        }
        if (this.extendsOrImplements(toType.type)) {
            return new SupertypeCastExpression(position, value, toType);
        }
        return new InvalidExpression(position, toType, CompileExceptionCode.INVALID_CAST, "Could not cast " + this.toString() + " to " + toType);
    }

    public Expression castExplicit(CodePosition position, Expression value, StoredType toType, boolean optional) {
        if (this.canCastImplicit(toType = toType.getNormalized())) {
            return this.castImplicit(position, value, toType, false);
        }
        TypeMembers typeMembers = this.cache.get(this.type.type.accept(new TagRemovingTypeVisitor(this.cache)));
        if (this.type.type != typeMembers.type.type && typeMembers.canCast(toType)) {
            return typeMembers.castExplicit(position, value, toType, optional);
        }
        for (TypeMember<CasterMemberRef> caster : this.casters) {
            if (!this.areEquivalent(((CasterMemberRef)caster.member).toType, toType)) continue;
            return this.castEquivalent(position, ((CasterMemberRef)caster.member).cast(position, value, false), toType);
        }
        return new InvalidExpression(position, toType, CompileExceptionCode.INVALID_CAST, "Cannot cast " + this.toString() + " to " + toType + ", even explicitly");
    }

    public boolean hasMember(String name) {
        return this.members.containsKey(name);
    }

    public IPartialExpression getMemberExpression(CodePosition position, TypeScope scope, Expression target, GenericName name, boolean allowStatic) {
        if (this.members.containsKey(name.name)) {
            TypeMemberGroup group = this.members.get(name.name);
            if (group.isStatic) {
                return new PartialStaticMemberGroupExpression(position, scope, this.type.type, group, name.arguments);
            }
            return new PartialMemberGroupExpression(position, scope, target, group, name.arguments, allowStatic);
        }
        return null;
    }

    public IPartialExpression getStaticMemberExpression(CodePosition position, TypeScope scope, GenericName name) {
        if (this.members.containsKey(name.name)) {
            return new PartialStaticMemberGroupExpression(position, scope, this.type.type, this.members.get(name.name), name.arguments);
        }
        if (this.innerTypes.containsKey(name.name)) {
            return new PartialTypeExpression(position, this.innerTypes.get(name.name).instance(this.cache.getRegistry(), name.arguments, (DefinitionTypeID)this.type.type), name.arguments);
        }
        if (this.variantOptions.containsKey(name.name)) {
            return new PartialVariantOptionExpression(position, scope, this.variantOptions.get(name.name));
        }
        return null;
    }

    public boolean hasInnerType(String name) {
        return this.innerTypes.containsKey(name);
    }

    public DefinitionTypeID getInnerType(CodePosition position, GenericName name) {
        if (!this.innerTypes.containsKey(name.name)) {
            throw new RuntimeException("No such inner type in " + this.type + ": " + name.name);
        }
        return this.innerTypes.get(name.name).instance(this.cache.getRegistry(), name.arguments, (DefinitionTypeID)this.type.type);
    }

    public String toString() {
        return this.type.toString();
    }
}

