/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.expression;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionTransformer;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitorWithContext;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;

public class ConstructorSuperCallExpression
extends Expression {
    public final StoredType objectType;
    public final FunctionalMemberRef constructor;
    public final CallArguments arguments;

    public ConstructorSuperCallExpression(CodePosition position, StoredType type, FunctionalMemberRef constructor, CallArguments arguments) {
        super(position, BasicTypeID.VOID.stored, ConstructorSuperCallExpression.binaryThrow(position, constructor.getHeader().thrownType, ConstructorSuperCallExpression.multiThrow(position, arguments.arguments)));
        this.objectType = type;
        this.constructor = constructor;
        this.arguments = arguments;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitConstructorSuperCall(this);
    }

    @Override
    public <C, R> R accept(C context, ExpressionVisitorWithContext<C, R> visitor) {
        return visitor.visitConstructorSuperCall(context, this);
    }

    @Override
    public Expression transform(ExpressionTransformer transformer) {
        CallArguments tArguments = this.arguments.transform(transformer);
        return tArguments == this.arguments ? this : new ConstructorSuperCallExpression(this.position, this.type, this.constructor, tArguments);
    }

    @Override
    public Expression normalize(TypeScope scope) {
        return new ConstructorSuperCallExpression(this.position, this.type.getNormalized(), this.constructor, this.arguments.normalize(this.position, scope, this.constructor.getHeader()));
    }
}

