/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.world;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.entity.MCEntityClassification;
import com.blamejared.crafttweaker.impl.util.MCBlockPos;
import com.blamejared.crafttweaker.impl.world.MCBiomeSpawnEntry;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.ZenWrapper;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.biome.Biome;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.world.MCBiome")
@Document(value="vanilla/api/world/MCBiome")
@ZenWrapper(wrappedClass="net.minecraft.world.biome.Biome", conversionMethodFormat="%s.getInternal()")
public class MCBiome {
    private final Biome internal;

    public MCBiome(Biome internal) {
        this.internal = internal;
    }

    @ZenCodeType.Getter(value="waterColor")
    public int getWaterFloat() {
        return this.getInternal().func_185361_o();
    }

    @ZenCodeType.Getter(value="waterFogColor")
    public int getWaterFogColor() {
        return this.getInternal().func_204274_p();
    }

    @ZenCodeType.Getter(value="defaultTemperature")
    public float getDefaultTemperature() {
        return this.getInternal().func_185353_n();
    }

    @ZenCodeType.Getter(value="translationKey")
    public String getTranslationKey() {
        return this.getInternal().func_210773_k();
    }

    @ZenCodeType.Getter(value="scale")
    public float getScale() {
        return this.getInternal().func_185360_m();
    }

    @ZenCodeType.Getter(value="downfall")
    public float getDownFall() {
        return this.getInternal().func_76727_i();
    }

    @ZenCodeType.Getter(value="depth")
    public float getDepth() {
        return this.getInternal().func_185355_j();
    }

    @ZenCodeType.Getter(value="spawningChange")
    public float getSpawningChance() {
        return this.getInternal().func_76741_f();
    }

    @ZenCodeType.Getter(value="isHighHumidity")
    public boolean isHighHumidity() {
        return this.getInternal().func_76736_e();
    }

    @ZenCodeType.Getter(value="isMutation")
    public boolean isMutation() {
        return this.getInternal().func_185363_b();
    }

    @ZenCodeType.Getter(value="category")
    public String getCategory() {
        return this.getInternal().func_201856_r().func_222352_a().toLowerCase();
    }

    @ZenCodeType.Getter(value="isTempOcean")
    public boolean isTempOcean() {
        return this.getInternal().func_150561_m() == Biome.TempCategory.OCEAN;
    }

    @ZenCodeType.Getter(value="isTempCold")
    public boolean isTempCold() {
        return this.getInternal().func_150561_m() == Biome.TempCategory.COLD;
    }

    @ZenCodeType.Getter(value="isTempMedium")
    public boolean isTempMedium() {
        return this.getInternal().func_150561_m() == Biome.TempCategory.MEDIUM;
    }

    @ZenCodeType.Getter(value="isTempWarm")
    public boolean isTempWarm() {
        return this.getInternal().func_150561_m() == Biome.TempCategory.WARM;
    }

    @ZenCodeType.Getter(value="doesRain")
    public boolean doesRain() {
        return this.getInternal().func_201851_b() == Biome.RainType.RAIN;
    }

    @ZenCodeType.Getter(value="doesSnow")
    public boolean doesSnow() {
        return this.getInternal().func_201851_b() == Biome.RainType.SNOW;
    }

    @ZenCodeType.Getter(value="rainType")
    public String getRainType() {
        return this.getInternal().func_201851_b().func_222361_a();
    }

    @ZenCodeType.Getter(value="parent")
    public String getParent() {
        return this.getInternal().func_205402_s();
    }

    @ZenCodeType.Method
    public String getTempCategory() {
        return this.getInternal().func_150561_m().func_222357_a().toLowerCase();
    }

    @ZenCodeType.Method
    public float getTemperature(MCBlockPos pos) {
        return this.getInternal().func_225486_c(pos.getInternal());
    }

    @ZenCodeType.Method
    public List<MCBiomeSpawnEntry> getSpawns(MCEntityClassification classification) {
        return this.getInternal().func_76747_a(classification.getInternal()).stream().map(MCBiomeSpawnEntry::new).collect(Collectors.toList());
    }

    public Biome getInternal() {
        return this.internal;
    }
}

