/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.food;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.potion.MCEffectInstance;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.ZenWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.Food;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Util;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.food.MCFood")
@ZenRegister
@Document(value="vanilla/api/food/MCFood")
@ZenWrapper(wrappedClass="net.minecraft.item.food", conversionMethodFormat="%s.getInternal()")
public class MCFood {
    private final Food internal;
    private final Field effects = (Field)Util.func_199748_a(() -> ObfuscationReflectionHelper.findField(Food.class, (String)"field_221475_f"));

    public MCFood(Food internal) {
        this.internal = internal;
    }

    @ZenCodeType.Constructor
    public MCFood(int healing, float saturation) {
        this(new Food.Builder().func_221456_a(healing).func_221454_a(saturation).func_221453_d());
    }

    @ZenCodeType.Getter(value="healing")
    public int getHealing() {
        return this.getInternal().func_221466_a();
    }

    @ZenCodeType.Method
    public MCFood setHealing(int healing) {
        Food food = this.copyInternal();
        food.field_221470_a = healing;
        return new MCFood(food);
    }

    @ZenCodeType.Getter(value="saturation")
    public float getSaturation() {
        return this.getInternal().func_221469_b();
    }

    @ZenCodeType.Method
    public MCFood setSaturation(float saturation) {
        Food food = this.copyInternal();
        food.field_221471_b = saturation;
        return new MCFood(food);
    }

    @ZenCodeType.Getter(value="meat")
    public boolean isMeat() {
        return this.getInternal().func_221467_c();
    }

    @ZenCodeType.Method
    public MCFood setMeat(boolean meat) {
        Food food = this.copyInternal();
        food.field_221472_c = meat;
        return new MCFood(food);
    }

    @ZenCodeType.Getter(value="canEatWhenFull")
    public boolean canEatWhenFull() {
        return this.getInternal().func_221468_d();
    }

    @ZenCodeType.Method
    public MCFood setCanEatWhenFull(boolean canEatWhenFull) {
        Food food = this.copyInternal();
        food.field_221473_d = canEatWhenFull;
        return new MCFood(food);
    }

    @ZenCodeType.Getter(value="isFastEating")
    public boolean isFastEating() {
        return this.getInternal().func_221465_e();
    }

    @ZenCodeType.Method
    public MCFood setFastEating(boolean fastEating) {
        Food food = this.copyInternal();
        food.field_221474_e = fastEating;
        return new MCFood(food);
    }

    @ZenCodeType.Method
    public void clearEffects() {
        this.getEffects().clear();
    }

    @ZenCodeType.Method
    public MCFood addEffect(MCEffectInstance effect, float probability) {
        Food food = this.copyInternal();
        this.getEffects().add((Pair<Supplier<EffectInstance>, Float>)Pair.of(effect::getInternal, (Object)Float.valueOf(probability)));
        return new MCFood(food);
    }

    @ZenCodeType.Method
    public MCFood removeEffect(MCEffectInstance effect) {
        Food food = this.copyInternal();
        this.getEffects().removeIf(pair -> ((EffectInstance)((Supplier)pair.getLeft()).get()).equals((Object)effect.getInternal()));
        return new MCFood(food);
    }

    public Food getInternal() {
        return this.internal;
    }

    private List<Pair<Supplier<EffectInstance>, Float>> getEffects() {
        try {
            return (List)this.effects.get(this.getInternal());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return new ArrayList<Pair<Supplier<EffectInstance>, Float>>();
        }
    }

    private Food copyInternal() {
        Food.Builder builder = new Food.Builder();
        if (this.isMeat()) {
            builder.func_221451_a();
        }
        if (this.isFastEating()) {
            builder.func_221457_c();
        }
        builder.func_221454_a(this.getSaturation());
        builder.func_221456_a(this.getHealing());
        for (Pair effect : this.getInternal().func_221464_f()) {
            builder.func_221452_a((EffectInstance)effect.getKey(), ((Float)effect.getRight()).floatValue());
        }
        return builder.func_221453_d();
    }
}

