/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.tree;

import com.terraforged.mod.TerraWorld;
import com.terraforged.mod.chunk.TerraChunkGenerator;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.feature.tree.SaplingFeature;
import com.terraforged.mod.feature.tree.SaplingManager;
import com.terraforged.mod.feature.tree.SaplingPlacer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SaplingBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SaplingListener {
    private static final BlockPos[] NONE = new BlockPos[]{BlockPos.field_177992_a};
    private static final Vec3i[][] DIRECTIONS = new Vec3i[][]{{new Vec3i(0, 0, 1), new Vec3i(1, 0, 1), new Vec3i(1, 0, 0)}, {new Vec3i(1, 0, 0), new Vec3i(1, 0, -1), new Vec3i(0, 0, -1)}, {new Vec3i(0, 0, -1), new Vec3i(-1, 0, -1), new Vec3i(-1, 0, 0)}, {new Vec3i(-1, 0, 0), new Vec3i(-1, 0, 1), new Vec3i(0, 0, 1)}};

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTreeGrow(SaplingGrowTreeEvent event) {
        BlockPos pos;
        if (event.getWorld().func_201670_d()) {
            return;
        }
        if (!TerraWorld.isTerraWorld(event.getWorld())) {
            return;
        }
        if (!SaplingListener.areCustomTreesEnabled(event.getWorld())) {
            return;
        }
        IWorld world = event.getWorld();
        Block block = world.func_180495_p(pos = event.getPos()).func_177230_c();
        if (block instanceof SaplingBlock) {
            SaplingFeature tree = SaplingManager.getSapling(block.getRegistryName());
            if (tree == null) {
                return;
            }
            Vec3i[] directions = SaplingListener.getNeighbourDirections(world, block, pos);
            if (directions.length == 1) {
                SaplingListener.placeNormal(tree, event, directions);
            } else {
                SaplingListener.placeGiant(tree, event, block, directions);
            }
        }
    }

    private static void placeNormal(SaplingFeature tree, SaplingGrowTreeEvent event, Vec3i[] directions) {
        SaplingPlacer.placeTree(tree.nextNormal(event.getRand()), event, directions);
    }

    private static void placeGiant(SaplingFeature tree, SaplingGrowTreeEvent event, Block type, Vec3i[] directions) {
        Feature<NoFeatureConfig> feature = tree.nextGiant(event.getRand());
        if (feature == null) {
            SaplingListener.placeNormal(tree, event, directions);
            return;
        }
        if (!SaplingPlacer.placeTree(feature, event, directions)) {
            return;
        }
        BlockPos pos = event.getPos();
        for (Vec3i dir : directions) {
            BlockPos blockPos = pos.func_177971_a(dir);
            BlockState state = event.getWorld().func_180495_p(blockPos);
            if (state.func_177230_c() != type) continue;
            event.getWorld().func_217377_a(blockPos, false);
        }
    }

    private static Vec3i[] getNeighbourDirections(IWorld world, Block block, BlockPos pos) {
        for (Vec3i[] dirs : DIRECTIONS) {
            boolean match = true;
            for (Vec3i dir : dirs) {
                BlockState state = world.func_180495_p(pos.func_177971_a(dir));
                if (state.func_177230_c() == block) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return dirs;
        }
        return NONE;
    }

    private static boolean areCustomTreesEnabled(IWorld world) {
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            ChunkGenerator generator = serverWorld.func_72863_F().field_186029_c;
            if (generator instanceof TerraChunkGenerator) {
                TerraContext context = ((TerraChunkGenerator)generator).getContext();
                return context.terraSettings.features.customBiomeFeatures;
            }
        }
        return false;
    }
}

