/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.decorator.poisson;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.region.chunk.ChunkReader;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.mod.chunk.TerraContainer;
import com.terraforged.mod.chunk.fix.RegionDelegate;
import me.dags.noise.Module;
import me.dags.noise.Source;
import me.dags.noise.util.NoiseUtil;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.WorldGenRegion;

public class BiomeVariance
implements Module {
    public static float MIN_FADE = 0.05f;
    private final ChunkReader chunk;
    private final float fade;
    private final float range;

    public BiomeVariance(ChunkReader chunk, float fade) {
        this.chunk = chunk;
        this.fade = fade;
        this.range = fade - MIN_FADE;
    }

    @Override
    public float getValue(float x, float y) {
        Cell<Terrain> cell = this.chunk.getCell((int)x, (int)y);
        return NoiseUtil.map(1.0f - cell.biomeEdge, MIN_FADE, this.fade, this.range);
    }

    public static Module of(IWorld world, float fade) {
        if (world instanceof RegionDelegate) {
            WorldGenRegion region = ((RegionDelegate)world).getRegion();
            IChunk chunk = region.func_212866_a_(region.func_201679_a(), region.func_201680_b());
            return BiomeVariance.of(chunk, fade);
        }
        return Source.ONE;
    }

    public static Module of(IChunk chunk, float fade) {
        BiomeContainer container = chunk.func_225549_i_();
        if (container instanceof TerraContainer) {
            ChunkReader reader = ((TerraContainer)container).getChunkReader();
            return new BiomeVariance(reader, fade);
        }
        return Source.ONE;
    }
}

