/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.decorator.surface;

import com.terraforged.api.chunk.surface.Surface;
import com.terraforged.api.chunk.surface.SurfaceContext;
import com.terraforged.api.material.layer.LayerMaterial;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.world.heightmap.Levels;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.core.world.terrain.Terrains;
import com.terraforged.mod.biome.provider.BiomeProvider;
import com.terraforged.mod.biome.provider.DesertBiomes;
import com.terraforged.mod.chunk.TerraContext;
import me.dags.noise.Module;
import me.dags.noise.Source;
import me.dags.noise.func.CellFunc;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;

public class DesertDunes
implements Surface {
    private final int maxHeight;
    private final Levels levels;
    private final Module module;
    private final Terrains terrains;
    private final DesertBiomes deserts;
    private final BlockPos.Mutable pos = new BlockPos.Mutable();

    public DesertDunes(TerraContext context, int maxHeight, DesertBiomes deserts) {
        Module dunes = Source.cell(context.seed.next(), 80, CellFunc.DISTANCE).warp(context.seed.next(), 70, 1, 70.0);
        this.terrains = context.terrain;
        this.levels = context.levels;
        this.maxHeight = maxHeight;
        this.deserts = deserts;
        this.module = dunes;
    }

    @Override
    public void buildSurface(int x, int z, int surface, SurfaceContext ctx) {
        float value = this.module.getValue(x, z) * DesertDunes.getMask(ctx.cell);
        float baseHeight = ctx.cell.value * (float)this.levels.worldHeight;
        float duneHeight = baseHeight + value * (float)this.maxHeight;
        int duneBase = (int)baseHeight;
        int duneTop = (int)duneHeight;
        if (duneTop < this.levels.waterLevel || (float)duneTop <= baseHeight) {
            return;
        }
        LayerMaterial material = this.deserts.getSandLayers(ctx.biome);
        if (material == null) {
            return;
        }
        this.fill(x, z, duneBase, duneTop, ctx, ctx.chunk, material.getFull());
        float depth = material.getDepth(duneHeight);
        int levels = material.getLevel(depth);
        BlockState top = material.getState(levels);
        ctx.chunk.func_177436_a((BlockPos)this.pos.func_181079_c(x, duneTop, z), top, false);
    }

    public static Surface create(TerraContext context, BiomeProvider provider) {
        return DesertDunes.create(context, provider.getModifierManager().getDesertBiomes());
    }

    public static Surface create(TerraContext context, DesertBiomes desertBiomes) {
        return new DesertDunes(context, 25, desertBiomes);
    }

    private static float getMask(Cell<Terrain> cell) {
        return cell.biomeMask(0.0f, 0.75f) * cell.mask(0.4f, 0.5f, 0.0f, 0.8f);
    }
}

