/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.decorator.base;

import com.terraforged.api.chunk.column.ColumnDecorator;
import com.terraforged.api.chunk.column.DecoratorContext;
import com.terraforged.api.material.state.States;
import com.terraforged.core.util.VariablePredicate;
import com.terraforged.core.world.terrain.Terrains;
import com.terraforged.mod.chunk.TerraContext;
import net.minecraft.block.BlockState;
import net.minecraft.world.chunk.IChunk;

public class CoastDecorator
implements ColumnDecorator {
    private final Terrains terrains;
    private final BlockState sand;
    private final BlockState gravel;
    private final VariablePredicate height;

    public CoastDecorator(TerraContext context) {
        int min = context.levels.waterLevel - 5;
        int max = context.levels.waterLevel + 16;
        this.sand = (BlockState)States.SAND.get();
        this.gravel = (BlockState)States.GRAVEL.get();
        this.terrains = context.terrain;
        this.height = VariablePredicate.height(context.seed, context.levels, min, max, 75, 1);
    }

    @Override
    public void decorate(IChunk chunk, DecoratorContext context, int x, int y, int z) {
        if (context.cell.tag != this.terrains.beach) {
            return;
        }
        if (!this.height.test(context.cell, x, z)) {
            return;
        }
        if (context.cell.temperature < 0.3f) {
            this.setState(chunk, x, y, z, this.gravel, false);
        } else {
            this.setState(chunk, x, y, z, this.sand, false);
        }
    }
}

