/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.test;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.cell.Populator;
import com.terraforged.core.region.gen.RegionCache;
import com.terraforged.core.region.gen.RegionGenerator;
import com.terraforged.core.util.concurrent.ThreadPool;
import com.terraforged.core.world.GeneratorContext;
import com.terraforged.core.world.WorldGeneratorFactory;
import com.terraforged.core.world.heightmap.WorldHeightmap;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.mod.biome.provider.BiomeProvider;
import com.terraforged.mod.chunk.TerraChunkGenerator;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.chunk.test.Test;
import com.terraforged.mod.chunk.test.TestBiomeProvider;
import net.minecraft.world.gen.GenerationSettings;

public class TestChunkGenerator
extends TerraChunkGenerator {
    private final BiomeProvider biomeProvider;

    public TestChunkGenerator(TerraContext context, BiomeProvider biomeProvider, GenerationSettings settings) {
        super(context, biomeProvider, settings);
        this.biomeProvider = new TestBiomeProvider(context);
    }

    @Override
    protected RegionCache createRegionCache(TerraContext context) {
        return RegionGenerator.builder().factory(new WorldGeneratorFactory(context, new TestHeightMap(context))).pool(ThreadPool.getPool()).size(3, 2).build().toCache(false);
    }

    @Override
    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    private static class TestHeightMap
    extends WorldHeightmap {
        private final Populator populator;

        public TestHeightMap(GeneratorContext context) {
            super(context);
            this.populator = this.getPopulator(Test.getTerrainType(context.terrain));
        }

        @Override
        public void apply(Cell<Terrain> cell, float x, float y) {
            super.apply(cell, x, y);
            this.populator.apply(cell, x, y);
        }

        @Override
        public void tag(Cell<Terrain> cell, float x, float y) {
            this.populator.tag(cell, x, y);
        }
    }
}

