/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.fix;

import com.terraforged.api.chunk.ChunkDelegate;
import com.terraforged.api.material.state.States;
import com.terraforged.mod.material.MaterialHelper;
import com.terraforged.mod.material.Materials;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;

public class ChunkCarverFix
implements ChunkDelegate {
    private final IChunk delegate;
    private final Materials materials;

    public ChunkCarverFix(IChunk chunk, Materials materials) {
        this.delegate = chunk;
        this.materials = materials;
    }

    @Override
    public IChunk getDelegate() {
        return this.delegate;
    }

    @Override
    public BlockState func_180495_p(BlockPos pos) {
        BlockState state = this.getDelegate().func_180495_p(pos);
        if (MaterialHelper.isAir(state.func_177230_c())) {
            return state;
        }
        if (MaterialHelper.isGrass(state.func_177230_c())) {
            return (BlockState)States.GRASS_BLOCK.get();
        }
        if (this.materials.isStone(state.func_177230_c())) {
            return (BlockState)States.STONE.get();
        }
        if (this.materials.isEarth(state.func_177230_c())) {
            return (BlockState)States.DIRT.get();
        }
        if (this.materials.isClay(state.func_177230_c())) {
            return (BlockState)States.DIRT.get();
        }
        if (this.materials.isSediment(state.func_177230_c())) {
            return (BlockState)States.SAND.get();
        }
        return state;
    }
}

