/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk;

import com.terraforged.mod.chunk.fix.SpawnFix;
import com.terraforged.mod.util.annotation.Name;
import com.terraforged.mod.util.annotation.Ref;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.OverworldChunkGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.CatSpawner;
import net.minecraft.world.spawner.PatrolSpawner;
import net.minecraft.world.spawner.PhantomSpawner;
import net.minecraft.world.spawner.WorldEntitySpawner;

@Ref(value={OverworldChunkGenerator.class, NoiseChunkGenerator.class, ChunkGenerator.class})
public abstract class ObfHelperChunkGenerator<T extends GenerationSettings>
extends ChunkGenerator<T> {
    private final CatSpawner catSpawner = new CatSpawner();
    private final PatrolSpawner patrolSpawner = new PatrolSpawner();
    private final PhantomSpawner phantomSpawner = new PhantomSpawner();
    private final INoiseGenerator surfaceNoise;

    public ObfHelperChunkGenerator(IWorld world, BiomeProvider biomeProvider, T settings) {
        super(world, biomeProvider, settings);
        SharedSeedRandom random = new SharedSeedRandom(world.func_72905_C());
        this.surfaceNoise = new PerlinNoiseGenerator(random, 3, 0);
    }

    public final void func_222528_a(IWorld world, IChunk chunk) {
        try {
            super.func_222528_a(world, chunk);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public final void func_222537_b(IWorld world, IChunk chunk) {
        this.generateBase(world, chunk);
    }

    public final void func_225551_a_(WorldGenRegion world, IChunk chunk) {
        this.generateSurface(world, chunk);
    }

    public final List<Biome.SpawnListEntry> func_177458_a(EntityClassification type, BlockPos pos) {
        if (Feature.field_202334_l.func_202383_b(this.field_222540_a, pos)) {
            if (type == EntityClassification.MONSTER) {
                return Feature.field_202334_l.func_202279_e();
            }
            if (type == EntityClassification.CREATURE) {
                return Feature.field_202334_l.func_214469_f();
            }
        } else if (type == EntityClassification.MONSTER) {
            if (Feature.field_214536_b.func_175796_a(this.field_222540_a, pos)) {
                return Feature.field_214536_b.func_202279_e();
            }
            if (Feature.field_202336_n.func_175796_a(this.field_222540_a, pos)) {
                return Feature.field_202336_n.func_202279_e();
            }
        }
        return super.func_177458_a(type, pos);
    }

    public final void func_202093_c(WorldGenRegion region) {
        if (SpawnFix.canSpawnMobs()) {
            int chunkX = region.func_201679_a();
            int chunkZ = region.func_201680_b();
            Biome biome = region.func_212866_a_(chunkX, chunkZ).func_225549_i_().func_225526_b_(0, 0, 0);
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
            sharedseedrandom.func_202424_a(region.func_72905_C(), chunkX << 4, chunkZ << 4);
            WorldEntitySpawner.func_77191_a((IWorld)region, (Biome)biome, (int)chunkX, (int)chunkZ, (Random)sharedseedrandom);
        }
    }

    public final void func_203222_a(ServerWorld worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        this.phantomSpawner.func_203232_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
        this.patrolSpawner.func_222696_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
        this.catSpawner.func_221124_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
    }

    @Name(value="getSurfaceLevel")
    public final int func_222529_a(int x, int z, Heightmap.Type type) {
        int level = this.getTopBlockY(x, z, type) + 1;
        if (type == Heightmap.Type.OCEAN_FLOOR || type == Heightmap.Type.OCEAN_FLOOR_WG) {
            return level;
        }
        return Math.max(this.func_222530_f(), level);
    }

    public final double getSurfaceNoise(int x, int z) {
        double scale = 0.0625;
        double noiseX = (double)x * scale;
        double noiseZ = (double)z * scale;
        double unusedValue1 = scale;
        double unusedValue2 = (double)(x & 0xF) * scale;
        return this.surfaceNoise.func_215460_a(noiseX, noiseZ, unusedValue1, unusedValue2);
    }

    public abstract int getTopBlockY(int var1, int var2, Heightmap.Type var3);

    public abstract void generateBase(IWorld var1, IChunk var2);

    public abstract void generateSurface(WorldGenRegion var1, IChunk var2);
}

