/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.spawn;

import com.terraforged.mod.Log;
import com.terraforged.mod.biome.provider.BiomeProvider;
import com.terraforged.mod.biome.spawn.SpawnSearch;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpawnHandler {
    @SubscribeEvent
    public static void createSpawn(WorldEvent.CreateSpawnPosition event) {
        ServerWorld world;
        if (event.getWorld() instanceof ServerWorld && (world = (ServerWorld)event.getWorld()).func_72863_F().func_201711_g().func_202090_b() instanceof BiomeProvider) {
            Log.info("Searching for world spawn position", new Object[0]);
            BiomeProvider provider = (BiomeProvider)world.func_72863_F().func_201711_g().func_202090_b();
            SpawnSearch search = new SpawnSearch(BlockPos.field_177992_a, provider);
            BlockPos spawn = search.get();
            Log.info("Setting world spawn: {}", spawn);
            event.setCanceled(true);
            event.getWorld().func_72912_H().func_176143_a(spawn);
            if (event.getSettings().func_77167_c()) {
                Log.info("Generating bonus chest", new Object[0]);
                SpawnHandler.createBonusChest(world, spawn);
            }
        }
    }

    private static void createBonusChest(ServerWorld world, BlockPos pos) {
        ConfiguredFeature chest = Feature.field_214487_aO.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        chest.func_222734_a((IWorld)world, world.func_72863_F().func_201711_g(), world.field_73012_v, pos);
    }
}

