/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.terraforged.feature.data.DataHelper;
import com.terraforged.feature.data.ResourceVisitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.packs.ModFileResourcePack;

public class DataPack {
    private final String namespace;
    private final ResourcePackType type;
    private final ModFileResourcePack pack;

    public DataPack(String namespace, ModFileResourcePack pack) {
        this.pack = pack;
        this.namespace = namespace;
        this.type = ResourcePackType.SERVER_DATA;
    }

    public Collection<ResourceLocation> getAllResources(String path, Predicate<String> filenameMatcher) {
        return this.pack.func_225637_a_(this.type, this.namespace, path, 8, filenameMatcher);
    }

    public InputStream getResource(ResourceLocation location) throws IOException {
        return this.pack.func_195761_a(this.type, location);
    }

    public void iterateData(String path, Predicate<String> matcher, ResourceVisitor<InputStream> consumer) {
        try {
            for (ResourceLocation location : this.getAllResources(path, matcher)) {
                InputStream data = this.getResource(location);
                Throwable throwable = null;
                try {
                    consumer.accept(location, data);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (data == null) continue;
                    if (throwable != null) {
                        try {
                            data.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    data.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void iterateJson(String path, ResourceVisitor<JsonElement> consumer) {
        JsonParser parser = new JsonParser();
        this.iterateData(path, DataHelper.JSON, (location, data) -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)data));
            JsonElement element = parser.parse((Reader)reader);
            consumer.accept(location, element);
        });
    }

    public static Optional<DataPack> getModDataPack(String modid) {
        return ModList.get().getModContainerById(modid).map(container -> {
            ModFileInfo fileInfo = ModList.get().getModFileById(modid);
            return new DataPack(container.getNamespace(), new ModFileResourcePack(fileInfo.getFile()));
        });
    }
}

