/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature;

import com.terraforged.feature.FeatureDecorator;
import com.terraforged.feature.biome.BiomeFeatures;
import com.terraforged.feature.modifier.FeatureModifierLoader;
import com.terraforged.feature.modifier.FeatureModifiers;
import com.terraforged.feature.modifier.ModifierSet;
import com.terraforged.feature.template.TemplateManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class FeatureManager
implements FeatureDecorator {
    public static final Logger LOG = LogManager.getLogger((String)"FeatureManager");
    public static final Marker INIT = MarkerManager.getMarker((String)"INIT");
    private final Map<Biome, BiomeFeatures> biomes;

    public FeatureManager(Map<Biome, BiomeFeatures> biomes) {
        this.biomes = biomes;
    }

    @Override
    public FeatureManager getFeatureManager() {
        return this;
    }

    public BiomeFeatures getFeatures(Biome biome) {
        return this.biomes.getOrDefault(biome, BiomeFeatures.NONE);
    }

    public static FeatureManager create(IWorld world) {
        FeatureModifiers modifiers = FeatureModifierLoader.load();
        return FeatureManager.create(world, modifiers);
    }

    public static FeatureManager create(IWorld world, FeatureModifiers modifiers) {
        LOG.debug(INIT, "Initializing FeatureManager");
        int predicates = modifiers.getPredicates().size();
        int replacers = modifiers.getReplacers().size();
        int injectors = modifiers.getInjectors().size();
        int transformers = modifiers.getTransformers().size();
        LOG.debug(INIT, " Predicates: {}, Replacers: {}, Injectors: {}, Transformers: {}", (Object)predicates, (Object)replacers, (Object)injectors, (Object)transformers);
        modifiers.sort();
        LOG.debug(INIT, " Compiling biome feature lists");
        HashMap<Biome, BiomeFeatures> biomes = new HashMap<Biome, BiomeFeatures>();
        for (Biome biome : ForgeRegistries.BIOMES) {
            BiomeFeatures features = FeatureManager.compute(biome, modifiers);
            biomes.put(biome, features);
        }
        LOG.debug(INIT, " Initialization complete");
        return new FeatureManager(biomes);
    }

    public static void registerTemplates(RegistryEvent.Register<Feature<?>> event) {
        TemplateManager.register(event);
    }

    private static BiomeFeatures compute(Biome biome, FeatureModifiers modifiers) {
        BiomeFeatures.Builder builder = BiomeFeatures.builder();
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            for (ConfiguredFeature feature : biome.func_203607_a(stage)) {
                ModifierSet modifierSet = modifiers.getFeature(biome, feature);
                builder.add(stage, modifierSet.before);
                builder.add(stage, modifierSet.feature);
                builder.add(stage, modifierSet.after);
            }
        }
        return builder.build();
    }
}

