/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.terrain;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.util.Seed;
import com.terraforged.core.world.heightmap.Levels;
import com.terraforged.core.world.heightmap.RegionConfig;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.core.world.terrain.TerrainPopulator;
import com.terraforged.core.world.terrain.Terrains;
import me.dags.noise.Module;
import me.dags.noise.Source;
import me.dags.noise.func.EdgeFunc;

public class VolcanoPopulator
extends TerrainPopulator {
    private static final float throat_value = 0.925f;
    private final Module cone;
    private final Module height;
    private final Module lowlands;
    private final float inversionPoint;
    private final float blendLower;
    private final float blendUpper;
    private final float blendRange;
    private final float bias;
    private final Terrain inner;
    private final Terrain outer;

    public VolcanoPopulator(Seed seed, RegionConfig region, Levels levels, Terrains terrains) {
        super(Source.ZERO, terrains.volcano);
        float midpoint = 0.3f;
        float range = 0.3f;
        Module heightNoise = Source.perlin(seed.next(), 2, 1).map(0.45, 0.65);
        this.height = Source.cellNoise(region.seed, region.scale, heightNoise).warp(region.warpX, region.warpZ, region.warpStrength);
        this.cone = Source.cellEdge(region.seed, region.scale, EdgeFunc.DISTANCE_2_DIV).invert().warp(region.warpX, region.warpZ, region.warpStrength).powCurve(11.0).clamp(0.475, 1.0).map(0.0, 1.0).grad(0.0, 0.5, 0.5).warp(seed.next(), 15, 2, 10.0).scale(this.height);
        this.lowlands = Source.ridge(seed.next(), 150, 3).warp(seed.next(), 30, 1, 30.0).scale(0.1);
        this.inversionPoint = 0.94f;
        this.blendLower = midpoint - range / 2.0f;
        this.blendUpper = this.blendLower + range;
        this.blendRange = this.blendUpper - this.blendLower;
        this.outer = terrains.volcano;
        this.inner = terrains.volcanoPipe;
        this.bias = levels.ground;
    }

    @Override
    public void apply(Cell<Terrain> cell, float x, float z) {
        float limit;
        float maxHeight;
        float value = this.cone.getValue(x, z);
        if (value > (maxHeight = (limit = this.height.getValue(x, z)) * this.inversionPoint)) {
            float steepnessModifier = 1.0f;
            float delta = (value - maxHeight) * steepnessModifier;
            float range = limit - maxHeight;
            float alpha = delta / range;
            if (alpha > 0.925f) {
                cell.tag = this.inner;
            }
            value = maxHeight - maxHeight / 5.0f * alpha;
        } else if (value < this.blendLower) {
            value += this.lowlands.getValue(x, z);
            cell.tag = this.outer;
        } else if (value < this.blendUpper) {
            float alpha = 1.0f - (value - this.blendLower) / this.blendRange;
            value += this.lowlands.getValue(x, z) * alpha;
            cell.tag = this.outer;
        }
        cell.value = this.bias + value;
    }

    @Override
    public void tag(Cell<Terrain> cell, float x, float z) {
        float range;
        float steepnessModifier;
        float delta;
        float alpha;
        float limit;
        float maxHeight;
        float value = this.cone.getValue(x, z);
        cell.tag = value > (maxHeight = (limit = this.height.getValue(x, z)) * this.inversionPoint) ? ((alpha = (delta = (value - maxHeight) * (steepnessModifier = 1.0f)) / (range = limit - maxHeight)) > 0.925f ? this.inner : this.outer) : this.outer;
    }
}

