/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.rivermap.river;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.world.rivermap.river.RiverBounds;
import com.terraforged.core.world.rivermap.river.RiverConfig;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.core.world.terrain.TerrainPopulator;
import com.terraforged.core.world.terrain.Terrains;
import me.dags.noise.Module;
import me.dags.noise.Source;
import me.dags.noise.source.Line;
import me.dags.noise.util.NoiseUtil;

public class River
extends TerrainPopulator {
    public static final int VALLEY_WIDTH = 275;
    protected static final float DEPTH_FADE_STRENGTH = 0.5f;
    public final boolean main;
    private final boolean connecting;
    private final float bedHeight;
    private final float minBankHeight;
    private final float maxBankHeight;
    private final float bankAlphaMin;
    private final float bankAlphaMax;
    private final float bankAlphaRange;
    private final Module bankVariance;
    private final Line bed;
    private final Line banks;
    private final Line valley;
    public final RiverConfig config;
    public final RiverBounds bounds;
    private final Terrains terrains;
    private final float depthFadeBias;

    public River(RiverBounds bounds, RiverConfig config, Terrains terrains, double fadeIn, double fadeOut) {
        this(bounds, config, terrains, fadeIn, fadeOut, false);
    }

    public River(RiverBounds bounds, RiverConfig config, Terrains terrains, double fadeIn, double fadeOut, boolean connecting) {
        super(Source.ZERO, terrains.river);
        Module in = Source.constant(fadeIn);
        Module out = Source.constant(fadeOut);
        Module bedWidth = Source.constant(config.bedWidth * config.bedWidth);
        Module bankWidth = Source.constant(config.bankWidth * config.bankWidth);
        Module valleyWidth = Source.constant(75625.0);
        this.bounds = bounds;
        this.config = config;
        this.main = config.main;
        this.terrains = terrains;
        this.connecting = connecting;
        this.bedHeight = config.bedHeight;
        this.minBankHeight = config.minBankHeight;
        this.maxBankHeight = config.maxBankHeight;
        this.bankAlphaMin = this.minBankHeight;
        this.bankAlphaMax = Math.min(1.0f, this.minBankHeight + 0.35f);
        this.bankAlphaRange = this.bankAlphaMax - this.bankAlphaMin;
        this.bankVariance = Source.perlin(1234, 150, 1);
        this.depthFadeBias = 0.5f;
        this.bed = Source.line((double)bounds.x1(), (double)bounds.y1(), (double)bounds.x2(), (double)bounds.y2(), bedWidth, in, out, (double)0.1f);
        this.banks = Source.line((double)bounds.x1(), (double)bounds.y1(), (double)bounds.x2(), (double)bounds.y2(), bankWidth, in, out, (double)0.1f);
        this.valley = Source.line((double)bounds.x1(), (double)bounds.y1(), (double)bounds.x2(), (double)bounds.y2(), valleyWidth, Source.ZERO, Source.ZERO, (double)0.33f);
    }

    @Override
    public void apply(Cell<Terrain> cell, float x, float z) {
        if (cell.value <= this.bedHeight) {
            return;
        }
        this.carve(cell, x, z);
    }

    @Override
    public void tag(Cell<Terrain> cell, float x, float z) {
        if (!this.terrains.overridesRiver((Terrain)cell.tag)) {
            cell.tag = this.terrains.river;
        }
    }

    private void carve(Cell<Terrain> cell, float x, float z) {
        float valleyAlpha = this.valley.getValue(x, z);
        if (valleyAlpha == 0.0f) {
            return;
        }
        cell.riverMask *= 1.0f - valleyAlpha;
        float bankHeight = this.getBankHeight(cell, x, z);
        if (!this.carveValley(cell, valleyAlpha, bankHeight)) {
            return;
        }
        if (this.connecting && this.banks.clipEnd(x, z)) {
            return;
        }
        float widthModifier = this.banks.getWidthModifier(x, z);
        float banksAlpha = this.banks.getValue(x, z, widthModifier);
        if (banksAlpha == 0.0f) {
            return;
        }
        float bedHeight = this.getBedHeight(bankHeight, widthModifier);
        if (!this.carveBanks(cell, banksAlpha, bedHeight)) {
            return;
        }
        float bedAlpha = this.bed.getValue(x, z);
        if (bedAlpha == 0.0f) {
            return;
        }
        this.carveBed(cell, bedHeight);
    }

    private float getBankHeight(Cell<Terrain> cell, float x, float z) {
        float bankHeightAlpha = NoiseUtil.map(cell.value, this.bankAlphaMin, this.bankAlphaMax, this.bankAlphaRange);
        float bankHeightVariance = this.bankVariance.getValue(x, z);
        return NoiseUtil.lerp(this.minBankHeight, this.maxBankHeight, bankHeightAlpha * bankHeightVariance);
    }

    private float getBedHeight(float bankHeight, float widthModifier) {
        float depthAlpha = this.depthFadeBias + 0.5f * widthModifier;
        return NoiseUtil.lerp(bankHeight, this.bedHeight, depthAlpha);
    }

    private boolean carveValley(Cell<Terrain> cell, float valleyAlpha, float bankHeight) {
        if (cell.value > bankHeight) {
            cell.value = NoiseUtil.lerp(cell.value, bankHeight, valleyAlpha);
        }
        return true;
    }

    private boolean carveBanks(Cell<Terrain> cell, float banksAlpha, float bedHeight) {
        if (cell.value > bedHeight) {
            cell.value = NoiseUtil.lerp(cell.value, bedHeight, banksAlpha);
            this.tag(cell, this.terrains.riverBanks);
            return true;
        }
        return false;
    }

    private void carveBed(Cell<Terrain> cell, float bedHeight) {
        if (cell.value > bedHeight) {
            cell.value = bedHeight;
        }
        this.tag(cell, this.terrains.river);
    }

    private void tag(Cell<Terrain> cell, Terrain tag) {
        if (!this.terrains.overridesRiver((Terrain)cell.tag)) {
            cell.tag = tag;
        }
    }

    public static boolean validStart(float value) {
        return value > 0.2734375f;
    }

    public static boolean validEnd(float value) {
        return value < 0.234375f;
    }
}

